/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.GovernedReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.OwnerType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Asset
extends GovernedReferenceable {
    private static final long serialVersionUID = 1L;
    protected String displayName = null;
    protected String shortDescription = null;
    protected String description = null;
    protected String owner = null;
    protected String ownerTypeName = null;
    protected String ownerPropertyName = null;
    protected OwnerType ownerType = null;
    protected List<String> zoneMembership = null;
    protected Map<String, String> origin = null;
    protected boolean isReferenceData = false;

    public Asset() {
    }

    public Asset(Asset template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.shortDescription = template.getShortDescription();
            this.description = template.getDescription();
            this.owner = template.getOwner();
            this.ownerTypeName = template.getOwnerTypeName();
            this.ownerPropertyName = template.getOwnerPropertyName();
            this.ownerType = template.getOwnerType();
            this.zoneMembership = template.getZoneMembership();
            this.origin = template.getAssetOrigin();
            this.isReferenceData = template.isReferenceData();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwnerTypeName() {
        return this.ownerTypeName;
    }

    public void setOwnerTypeName(String ownerTypeName) {
        this.ownerTypeName = ownerTypeName;
    }

    public String getOwnerPropertyName() {
        return this.ownerPropertyName;
    }

    public void setOwnerPropertyName(String ownerPropertyName) {
        this.ownerPropertyName = ownerPropertyName;
    }

    public OwnerType getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(OwnerType ownerType) {
        this.ownerType = ownerType;
    }

    public List<String> getZoneMembership() {
        if (this.zoneMembership == null) {
            return null;
        }
        if (this.zoneMembership.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.zoneMembership);
    }

    public void setZoneMembership(List<String> zoneMembership) {
        this.zoneMembership = zoneMembership;
    }

    public Map<String, String> getAssetOrigin() {
        if (this.origin == null) {
            return null;
        }
        if (this.origin.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.origin);
    }

    public void setAssetOrigin(Map<String, String> origin) {
        this.origin = origin;
    }

    public boolean isReferenceData() {
        return this.isReferenceData;
    }

    public void setReferenceData(boolean referenceData) {
        this.isReferenceData = referenceData;
    }

    @Override
    public String toString() {
        return "Asset{displayName='" + this.displayName + "', shortDescription='" + this.shortDescription + "', description='" + this.description + "', owner='" + this.owner + "', ownerType=" + this.ownerType + ", ownerTypeName=" + this.ownerTypeName + ", ownerPropertyName=" + this.ownerPropertyName + ", zoneMembership=" + this.zoneMembership + ", origin=" + this.origin + ", latestChange='" + this.latestChange + "', qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + this.getAdditionalProperties() + ", meanings=" + this.getMeanings() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + "', URL='" + this.getURL() + "', classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Asset asset = (Asset)objectToCompare;
        return this.isReferenceData == asset.isReferenceData && Objects.equals(this.displayName, asset.displayName) && Objects.equals(this.shortDescription, asset.shortDescription) && Objects.equals(this.description, asset.description) && Objects.equals(this.owner, asset.owner) && Objects.equals(this.ownerTypeName, asset.ownerTypeName) && Objects.equals(this.ownerPropertyName, asset.ownerPropertyName) && this.ownerType == asset.ownerType && Objects.equals(this.zoneMembership, asset.zoneMembership) && Objects.equals(this.origin, asset.origin);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.displayName, this.shortDescription, this.description, this.owner, this.ownerTypeName, this.ownerPropertyName, this.ownerType, this.zoneMembership, this.origin, this.isReferenceData);
    }
}

