/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyElementBase;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementType;

public abstract class AssetDescriptor
extends AssetPropertyElementBase {
    private static final long serialVersionUID = 1L;
    protected Asset assetBean;
    private String assetName = "<Unknown>";
    private String assetTypeName = "<Unknown>";
    private List<String> assetSuperTypeNames = null;

    protected AssetDescriptor() {
        this.setAssetBean(null);
    }

    public AssetDescriptor(Asset assetBean) {
        this.setAssetBean(assetBean);
    }

    public AssetDescriptor(AssetDescriptor templateAssetDescriptor) {
        if (templateAssetDescriptor != null) {
            this.setAssetBean(templateAssetDescriptor.getAssetBean());
            this.assetName = templateAssetDescriptor.getAssetName();
            this.assetTypeName = templateAssetDescriptor.getAssetTypeName();
            this.assetSuperTypeNames = templateAssetDescriptor.getAssetSuperTypeNames();
        } else {
            this.setAssetBean(null);
        }
    }

    protected void setAssetBean(Asset assetBean) {
        if (assetBean == null) {
            this.assetBean = new Asset();
        } else {
            ElementType elementType;
            this.assetBean = assetBean;
            String qualifiedName = assetBean.getQualifiedName();
            String displayName = assetBean.getDisplayName();
            if (qualifiedName == null || qualifiedName.equals("")) {
                if (displayName != null && !displayName.equals("")) {
                    this.assetName = displayName;
                }
            } else {
                this.assetName = qualifiedName;
            }
            if ((elementType = assetBean.getType()) != null) {
                String typeName = elementType.getTypeName();
                if (typeName != null && !typeName.equals("")) {
                    this.assetTypeName = typeName;
                }
                this.assetSuperTypeNames = elementType.getSuperTypeNames();
            }
        }
    }

    protected Asset getAssetBean() {
        return this.assetBean;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getAssetTypeName() {
        return this.assetTypeName;
    }

    public List<String> getAssetSuperTypeNames() {
        if (this.assetSuperTypeNames == null) {
            return null;
        }
        if (this.assetSuperTypeNames.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.assetSuperTypeNames);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetDescriptor that = (AssetDescriptor)objectToCompare;
        return Objects.equals(this.assetBean, that.assetBean) && Objects.equals(this.assetName, that.assetName) && Objects.equals(this.assetTypeName, that.assetTypeName) && Objects.equals(this.assetSuperTypeNames, that.assetSuperTypeNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.assetBean, this.assetName, this.assetTypeName, this.assetSuperTypeNames);
    }
}

