/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectedAssetProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;

public abstract class Connector {
    private final Map<String, Integer> counterMap = new HashMap<String, Integer>();
    private final Map<String, String> propertyMap = new HashMap<String, String>();
    private final Map<String, Date> timestampMap = new HashMap<String, Date>();

    protected Connector() {
    }

    public abstract void initialize(String var1, ConnectionProperties var2);

    public abstract String getConnectorInstanceId();

    public abstract ConnectionProperties getConnection();

    public abstract void initializeConnectedAssetProperties(ConnectedAssetProperties var1);

    public abstract ConnectedAssetProperties getConnectedAssetProperties(String var1) throws PropertyServerException, UserNotAuthorizedException;

    public abstract void start() throws ConnectorCheckedException;

    public Map<String, Object> getConnectorStatistics() {
        HashMap<String, Object> statistics = new HashMap<String, Object>();
        if (!this.counterMap.isEmpty()) {
            statistics.putAll(this.counterMap);
        }
        if (!this.propertyMap.isEmpty()) {
            statistics.putAll(this.propertyMap);
        }
        if (!this.timestampMap.isEmpty()) {
            statistics.putAll(this.timestampMap);
        }
        if (statistics.isEmpty()) {
            return null;
        }
        return statistics;
    }

    public void initializeStatisticCounter(String counterName, int counterValue, String methodName) throws InvalidParameterException {
        String actionDescription = "initialize a counter statistic";
        String parameterName = "counterName";
        if (this.propertyMap.get(counterName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(counterName, methodName, "initialize a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        if (this.timestampMap.get(counterName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(counterName, methodName, "initialize a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        this.counterMap.put(counterName, counterValue);
    }

    public void incrementStatisticCounter(String counterName, String methodName) throws InvalidParameterException {
        String actionDescription = "increment a counter statistic";
        String parameterName = "counterName";
        if (this.propertyMap.get(counterName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        if (this.timestampMap.get(counterName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        int counterValue = 1;
        if (this.counterMap.get(counterName) != null) {
            counterValue = this.counterMap.get(counterName);
        }
        this.counterMap.put(counterName, counterValue);
    }

    public int getStatisticCounter(String counterName, String methodName) throws InvalidParameterException {
        String actionDescription = "increment a counter statistic";
        String parameterName = "counterName";
        if (this.propertyMap.get(counterName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        if (this.timestampMap.get(counterName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(counterName, methodName, "increment a counter statistic"), this.getClass().getName(), methodName, "counterName");
        }
        this.counterMap.putIfAbsent(counterName, 0);
        return this.counterMap.get(counterName);
    }

    public void setStatisticProperty(String propertyName, String propertyValue, String methodName) throws InvalidParameterException {
        String actionDescription = "set a property statistic";
        String parameterName = "propertyName";
        if (this.counterMap.get(propertyName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(propertyName, methodName, "set a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        if (this.timestampMap.get(propertyName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(propertyName, methodName, "set a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        this.propertyMap.put(propertyName, propertyValue);
    }

    public void clearStatisticProperty(String propertyName, String methodName) throws InvalidParameterException {
        String actionDescription = "remove a property statistic";
        String parameterName = "propertyName";
        if (this.counterMap.get(propertyName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(propertyName, methodName, "remove a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        if (this.timestampMap.get(propertyName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(propertyName, methodName, "remove a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        this.propertyMap.remove(propertyName);
    }

    public String getStatisticProperty(String propertyName, String methodName) throws InvalidParameterException {
        String actionDescription = "retrieve a property statistic";
        String parameterName = "propertyName";
        if (this.counterMap.get(propertyName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(propertyName, methodName, "retrieve a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        if (this.timestampMap.get(propertyName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_TIMESTAMP_NAME.getMessageDefinition(propertyName, methodName, "retrieve a property statistic"), this.getClass().getName(), methodName, "propertyName");
        }
        return this.propertyMap.get(propertyName);
    }

    public void setStatisticTimestamp(String timestampName, Date timestampValue, String methodName) throws InvalidParameterException {
        String actionDescription = "set a timestamp statistic";
        String parameterName = "timestampName";
        if (this.counterMap.get(timestampName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(timestampName, methodName, "set a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        if (this.propertyMap.get(timestampName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(timestampName, methodName, "set a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        this.timestampMap.put(timestampName, timestampValue);
    }

    public void clearStatisticTimestamp(String timestampName, String methodName) throws InvalidParameterException {
        String actionDescription = "remove a timestamp statistic";
        String parameterName = "timestampName";
        if (this.counterMap.get(timestampName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(timestampName, methodName, "remove a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        if (this.propertyMap.get(timestampName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(timestampName, methodName, "remove a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        this.timestampMap.remove(timestampName);
    }

    public Date getStatisticTimestamp(String timestampName, String methodName) throws InvalidParameterException {
        String actionDescription = "retrieve a timestamp statistic";
        String parameterName = "timestampName";
        if (this.counterMap.get(timestampName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_COUNTER_NAME.getMessageDefinition(timestampName, methodName, "retrieve a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        if (this.propertyMap.get(timestampName) != null) {
            throw new InvalidParameterException(OCFErrorCode.ALREADY_PROPERTY_NAME.getMessageDefinition(timestampName, methodName, "retrieve a timestamp statistic"), this.getClass().getName(), methodName, "timestampName");
        }
        return this.timestampMap.get(timestampName);
    }

    public abstract void disconnect() throws ConnectorCheckedException;
}

