/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetCertifications;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetConnections;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDetail;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetExternalIdentifiers;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetExternalReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetFeedback;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLicenses;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLineage;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetLocations;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetMeaning;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetNoteLogs;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedAssets;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetRelatedMediaReferences;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Asset;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Meaning;

public class AssetUniverse
extends AssetDetail {
    private static final long serialVersionUID = 1L;
    protected List<AssetMeaning> meanings = null;
    protected AssetSchemaType schema = null;
    protected AssetFeedback feedback = null;
    protected AssetLocations knownLocations = null;
    protected AssetLineage lineage = null;
    protected AssetRelatedAssets relatedAssets = null;

    protected AssetUniverse() {
    }

    public AssetUniverse(Asset assetBean, AssetExternalIdentifiers externalIdentifiers, AssetRelatedMediaReferences relatedMediaReferences, AssetNoteLogs noteLogs, AssetExternalReferences externalReferences, AssetConnections connections, AssetLicenses licenses, AssetCertifications certifications, List<AssetMeaning> meanings, AssetSchemaType schema, AssetFeedback feedback, AssetLocations knownLocations, AssetLineage lineage, AssetRelatedAssets relatedAssets) {
        super(assetBean, externalIdentifiers, relatedMediaReferences, noteLogs, externalReferences, connections, licenses, certifications);
        this.meanings = meanings;
        this.schema = schema;
        this.feedback = feedback;
        this.knownLocations = knownLocations;
        this.lineage = lineage;
        this.relatedAssets = relatedAssets;
    }

    public AssetUniverse(AssetUniverse template) {
        super(template);
        if (template != null) {
            this.meanings = template.getMeanings();
            AssetSchemaType templateSchema = template.getSchema();
            AssetFeedback templateFeedback = template.getFeedback();
            AssetLocations templateLocations = template.getKnownLocations();
            AssetLineage templateLineage = template.getLineage();
            AssetRelatedAssets templateRelatedAssets = template.getRelatedAssets();
            if (templateSchema != null) {
                templateSchema.cloneAssetSchemaType(this);
            }
            if (templateFeedback != null) {
                this.feedback = new AssetFeedback((AssetDescriptor)this, templateFeedback);
            }
            if (templateLocations != null) {
                this.knownLocations = templateLocations.cloneIterator(this);
            }
            if (templateLineage != null) {
                this.lineage = new AssetLineage((AssetDescriptor)this, templateLineage);
            }
            if (templateRelatedAssets != null) {
                this.relatedAssets = templateRelatedAssets.cloneIterator(this);
            }
        }
    }

    public List<AssetMeaning> getMeanings() {
        List<Meaning> meanings = this.assetBean.getMeanings();
        if (meanings != null) {
            ArrayList<AssetMeaning> assetMeanings = new ArrayList<AssetMeaning>();
            for (Meaning meaning : meanings) {
                if (meaning == null) continue;
                assetMeanings.add(new AssetMeaning((AssetDescriptor)this, meaning));
            }
            if (!assetMeanings.isEmpty()) {
                return assetMeanings;
            }
        }
        return null;
    }

    public AssetSchemaType getSchema() {
        if (this.schema == null) {
            return null;
        }
        return this.schema.cloneAssetSchemaType(this);
    }

    public AssetFeedback getFeedback() {
        if (this.feedback == null) {
            return null;
        }
        return new AssetFeedback((AssetDescriptor)this, this.feedback);
    }

    public AssetLocations getKnownLocations() {
        if (this.knownLocations == null) {
            return null;
        }
        return this.knownLocations.cloneIterator(this);
    }

    public AssetLineage getLineage() {
        if (this.lineage == null) {
            return null;
        }
        return new AssetLineage((AssetDescriptor)this, this.lineage);
    }

    public AssetRelatedAssets getRelatedAssets() {
        if (this.relatedAssets == null) {
            return null;
        }
        return this.relatedAssets.cloneIterator(this);
    }

    @Override
    public String toString() {
        return "AssetUniverse{assetBean=" + this.assetBean + ", assetMeanings=" + this.meanings + ", schema=" + this.schema + ", feedback=" + this.feedback + ", knownLocations=" + this.knownLocations + ", lineage=" + this.lineage + ", relatedAssets=" + this.relatedAssets + ", externalIdentifiers=" + this.externalIdentifiers + ", relatedMediaReferences=" + this.relatedMediaReferences + ", noteLogs=" + this.noteLogs + ", externalReferences=" + this.externalReferences + ", connections=" + this.connections + ", licenses=" + this.licenses + ", certifications=" + this.certifications + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        AssetUniverse that = (AssetUniverse)objectToCompare;
        return Objects.equals(this.meanings, that.meanings) && Objects.equals(this.schema, that.schema) && Objects.equals(this.feedback, that.feedback) && Objects.equals(this.knownLocations, that.knownLocations) && Objects.equals(this.lineage, that.lineage) && Objects.equals(this.relatedAssets, that.relatedAssets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.meanings, this.schema, this.feedback, this.knownLocations, this.lineage, this.relatedAssets);
    }
}

