/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetDescriptor;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetPropertyBase;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;

public class EmbeddedConnectionProperties
extends AssetPropertyBase {
    private static final long serialVersionUID = 1L;
    protected EmbeddedConnection embeddedConnectionBean;

    public EmbeddedConnectionProperties(EmbeddedConnection embeddedConnectionBean) {
        super(null);
        this.embeddedConnectionBean = embeddedConnectionBean == null ? new EmbeddedConnection() : embeddedConnectionBean;
    }

    public EmbeddedConnectionProperties(AssetDescriptor parentAsset, EmbeddedConnection embeddedConnectionBean) {
        super(parentAsset);
        this.embeddedConnectionBean = embeddedConnectionBean == null ? new EmbeddedConnection() : embeddedConnectionBean;
    }

    public EmbeddedConnectionProperties(AssetDescriptor parentAsset, EmbeddedConnectionProperties template) {
        super(parentAsset, template);
        this.embeddedConnectionBean = template == null ? new EmbeddedConnection() : template.getEmbeddedConnectionBean();
    }

    protected EmbeddedConnection getEmbeddedConnectionBean() {
        return this.embeddedConnectionBean;
    }

    public int getPosition() {
        return this.embeddedConnectionBean.getPosition();
    }

    public String getDisplayName() {
        return this.embeddedConnectionBean.getDisplayName();
    }

    public ConnectionProperties getConnectionProperties() {
        Connection embeddedConnection = this.embeddedConnectionBean.getEmbeddedConnection();
        if (embeddedConnection == null) {
            return null;
        }
        return new ConnectionProperties(this.parentAsset, embeddedConnection);
    }

    public Map<String, Object> getArguments() {
        return this.embeddedConnectionBean.getArguments();
    }

    public String toString() {
        return this.embeddedConnectionBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EmbeddedConnectionProperties)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EmbeddedConnectionProperties that = (EmbeddedConnectionProperties)objectToCompare;
        return Objects.equals(this.getEmbeddedConnectionBean(), that.getEmbeddedConnectionBean());
    }

    @Override
    public int hashCode() {
        return this.embeddedConnectionBean.hashCode();
    }
}

