/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ExternalReference;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class License
extends Referenceable {
    private static final long serialVersionUID = 1L;
    protected String licenseGUID = null;
    protected String licenseTypeName = null;
    protected String licensee = null;
    protected String summary = null;
    protected ExternalReference link = null;
    protected Date startDate = null;
    protected Date endDate = null;
    protected String licenseConditions = null;
    protected String createdBy = null;
    protected String custodian = null;
    protected String notes = null;

    public License() {
    }

    public License(License template) {
        super(template);
        if (template != null) {
            Date templateEndDate;
            Date templateStartDate;
            this.licenseGUID = template.getLicenseGUID();
            this.licenseTypeName = template.getLicenseTypeName();
            this.licensee = template.getLicensee();
            this.summary = template.getSummary();
            ExternalReference templateLink = template.getLink();
            if (templateLink != null) {
                this.link = new ExternalReference(templateLink);
            }
            if ((templateStartDate = template.getStartDate()) != null) {
                this.startDate = new Date(templateStartDate.getTime());
            }
            if ((templateEndDate = template.getEndDate()) != null) {
                this.endDate = new Date(templateEndDate.getTime());
            }
            this.licenseConditions = template.getLicenseConditions();
            this.createdBy = template.getCreatedBy();
            this.custodian = template.getCustodian();
            this.notes = template.getNotes();
        }
    }

    public String getLicenseGUID() {
        return this.licenseGUID;
    }

    public void setLicenseGUID(String licenseGUID) {
        this.licenseGUID = licenseGUID;
    }

    public String getLicenseTypeName() {
        return this.licenseTypeName;
    }

    public void setLicenseTypeName(String licenseTypeName) {
        this.licenseTypeName = licenseTypeName;
    }

    public String getLicensee() {
        return this.licensee;
    }

    public void setLicensee(String licensee) {
        this.licensee = licensee;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public ExternalReference getLink() {
        if (this.link == null) {
            return null;
        }
        return new ExternalReference(this.link);
    }

    public void setLink(ExternalReference link) {
        this.link = link;
    }

    public Date getStartDate() {
        if (this.startDate == null) {
            return null;
        }
        return new Date(this.startDate.getTime());
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        if (this.endDate == null) {
            return null;
        }
        return new Date(this.endDate.getTime());
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getLicenseConditions() {
        return this.licenseConditions;
    }

    public void setLicenseConditions(String licenseConditions) {
        this.licenseConditions = licenseConditions;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCustodian() {
        return this.custodian;
    }

    public void setCustodian(String custodian) {
        this.custodian = custodian;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    @Override
    public String toString() {
        return "License{licenseGUID='" + this.licenseGUID + "', licenseTypeName='" + this.licenseTypeName + "', licensee='" + this.licensee + "', summary='" + this.summary + "', link=" + this.link + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", licenseConditions='" + this.licenseConditions + "', createdBy='" + this.createdBy + "', custodian='" + this.custodian + "', notes='" + this.notes + "', qualifiedName='" + this.qualifiedName + "', additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + "', url='" + this.url + "', classifications=" + this.classifications + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        License license = (License)objectToCompare;
        return Objects.equals(this.getLicenseGUID(), license.getLicenseGUID()) && Objects.equals(this.getLicenseTypeName(), license.getLicenseTypeName()) && Objects.equals(this.getLicensee(), license.getLicensee()) && Objects.equals(this.getSummary(), license.getSummary()) && Objects.equals(this.getLink(), license.getLink()) && Objects.equals(this.getStartDate(), license.getStartDate()) && Objects.equals(this.getEndDate(), license.getEndDate()) && Objects.equals(this.getLicenseConditions(), license.getLicenseConditions()) && Objects.equals(this.getCreatedBy(), license.getCreatedBy()) && Objects.equals(this.getCustodian(), license.getCustodian()) && Objects.equals(this.getNotes(), license.getNotes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLicenseGUID(), this.getLicenseTypeName(), this.getLicensee(), this.getSummary(), this.getLink(), this.getStartDate(), this.getEndDate(), this.getLicenseConditions(), this.getCreatedBy(), this.getCustodian(), this.getNotes());
    }
}

