/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.ffdc;

import java.util.Arrays;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyServerException
extends OCFCheckedExceptionBase {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(PropertyServerException.class);

    public PropertyServerException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription) {
        super(messageDefinition, className, actionDescription);
    }

    public PropertyServerException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, relatedProperties);
    }

    public PropertyServerException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Throwable caughtError) {
        super(messageDefinition, className, actionDescription, caughtError);
    }

    public PropertyServerException(ExceptionMessageDefinition messageDefinition, String className, String actionDescription, Throwable caughtError, Map<String, Object> relatedProperties) {
        super(messageDefinition, className, actionDescription, caughtError, relatedProperties);
    }

    public PropertyServerException(int httpCode, String className, String actionDescription, String errorMessage, String errorMessageId, String[] errorMessageParameters, String systemAction, String userAction, String caughtErrorClassName, Map<String, Object> relatedProperties) {
        super(httpCode, className, actionDescription, errorMessage, errorMessageId, errorMessageParameters, systemAction, userAction, caughtErrorClassName, relatedProperties);
        log.debug("{}, {}, {}, {}", new Object[]{httpCode, className, actionDescription, caughtErrorClassName});
    }

    public PropertyServerException(OCFCheckedExceptionBase template) {
        super(template);
    }

    @Override
    public String toString() {
        return "PropertyServerException{reportedHTTPCode=" + this.getReportedHTTPCode() + ", reportingClassName='" + this.getReportingClassName() + "', reportingActionDescription='" + this.getReportingActionDescription() + "', reportedErrorMessage='" + this.getReportedErrorMessage() + "', reportedErrorMessageId='" + this.getReportedErrorMessageId() + "', reportedErrorMessageParameters=" + Arrays.toString(this.getReportedErrorMessageParameters()) + ", reportedSystemAction='" + this.getReportedSystemAction() + "', reportedUserAction='" + this.getReportedUserAction() + "', reportedCaughtException=" + this.getReportedCaughtException() + ", reportedCaughtExceptionClassName='" + this.getReportedCaughtExceptionClassName() + "', relatedProperties=" + this.getRelatedProperties() + "}";
    }
}

