/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EmbeddedConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;

public class VirtualConnectionProperties
extends ConnectionProperties {
    protected VirtualConnection connectionBean;

    public VirtualConnectionProperties(VirtualConnection connectionBean) {
        super(connectionBean);
        this.connectionBean = connectionBean == null ? new VirtualConnection() : connectionBean;
    }

    public VirtualConnectionProperties(VirtualConnectionProperties templateConnection) {
        super(templateConnection);
        this.connectionBean = templateConnection == null ? new VirtualConnection() : new VirtualConnection(templateConnection.getConnectionBean());
    }

    @Override
    protected VirtualConnection getConnectionBean() {
        return this.connectionBean;
    }

    public List<EmbeddedConnectionProperties> getEmbeddedConnections() {
        List<EmbeddedConnection> embeddedConnectionBeans = this.connectionBean.getEmbeddedConnections();
        if (embeddedConnectionBeans == null) {
            return null;
        }
        ArrayList<EmbeddedConnectionProperties> embeddedConnectionPropertiesList = new ArrayList<EmbeddedConnectionProperties>();
        for (EmbeddedConnection embeddedConnectionBean : embeddedConnectionBeans) {
            embeddedConnectionPropertiesList.add(new EmbeddedConnectionProperties(embeddedConnectionBean));
        }
        return embeddedConnectionPropertiesList;
    }

    @Override
    public String getConnectionName() {
        String connectionName = "<Unknown>";
        String qualifiedName = this.connectionBean.getQualifiedName();
        String displayName = this.connectionBean.getDisplayName();
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            connectionName = qualifiedName;
        } else if (displayName != null && !displayName.isEmpty()) {
            connectionName = displayName;
        }
        return connectionName;
    }

    @Override
    public String getDescription() {
        return this.connectionBean.getDescription();
    }

    @Override
    public ConnectorTypeProperties getConnectorType() {
        ConnectorType connectorType = this.connectionBean.getConnectorType();
        if (connectorType == null) {
            return null;
        }
        return new ConnectorTypeProperties(connectorType);
    }

    @Override
    public EndpointProperties getEndpoint() {
        Endpoint endpoint = this.connectionBean.getEndpoint();
        if (endpoint == null) {
            return null;
        }
        return new EndpointProperties(endpoint);
    }

    @Override
    public Map<String, String> getSecuredProperties() {
        return this.connectionBean.getSecuredProperties();
    }

    @Override
    public String toString() {
        return this.connectionBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        VirtualConnectionProperties that = (VirtualConnectionProperties)objectToCompare;
        return Objects.equals((Object)this.getConnectionBean(), (Object)that.getConnectionBean());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getConnectionBean()});
    }
}

