/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProvider;
import org.odpi.openmetadata.frameworks.connectors.SecretsStoreConnector;
import org.odpi.openmetadata.frameworks.connectors.SecureConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.controls.SecretsStoreCollectionProperty;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFErrorCode;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFRuntimeException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EmbeddedConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.VirtualConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorBroker {
    private static final Logger log = LoggerFactory.getLogger(ConnectorBroker.class);
    private AuditLog auditLog = null;

    public ConnectorBroker() {
    }

    public ConnectorBroker(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    private void validateConnectionNotNull(ConnectionProperties connection) throws ConnectionCheckedException {
        VirtualConnectionProperties virtualConnection;
        List<EmbeddedConnectionProperties> embeddedConnections;
        String methodName = "validateConnectionNotNull";
        if (connection == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTION.getMessageDefinition(), this.getClass().getName(), "validateConnectionNotNull");
        }
        if (connection instanceof VirtualConnectionProperties && ((embeddedConnections = (virtualConnection = (VirtualConnectionProperties)connection).getEmbeddedConnections()) == null || embeddedConnections.isEmpty())) {
            throw new ConnectionCheckedException(OCFErrorCode.INVALID_VIRTUAL_CONNECTION.getMessageDefinition(connection.getConnectionName()), this.getClass().getName(), "validateConnectionNotNull");
        }
    }

    private ConnectorTypeProperties getConnectorType(ConnectionProperties connection, String methodName) throws ConnectionCheckedException {
        ConnectorTypeProperties requestedConnectorType = connection.getConnectorType();
        if (requestedConnectorType == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTOR_TYPE.getMessageDefinition(connection.getConnectionName()), this.getClass().getName(), methodName);
        }
        return requestedConnectorType;
    }

    private ConnectorProvider getConnectorProvider(ConnectorTypeProperties requestedConnectorType, String connectionName, String methodName) throws ConnectionCheckedException {
        ConnectorProvider connectorProvider;
        String connectorProviderClassName = requestedConnectorType.getConnectorProviderClassName();
        if (connectorProviderClassName == null) {
            throw new ConnectionCheckedException(OCFErrorCode.NULL_CONNECTOR_PROVIDER.getMessageDefinition(connectionName), this.getClass().getName(), methodName);
        }
        try {
            Class<?> connectorProviderClass = Class.forName(connectorProviderClassName);
            Object potentialConnectorProvider = connectorProviderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            connectorProvider = (ConnectorProvider)potentialConnectorProvider;
        }
        catch (ClassNotFoundException classException) {
            throw new ConnectionCheckedException(OCFErrorCode.UNKNOWN_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, connectionName), this.getClass().getName(), methodName, classException);
        }
        catch (ClassCastException castException) {
            throw new ConnectionCheckedException(OCFErrorCode.NOT_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, connectionName), this.getClass().getName(), methodName, castException);
        }
        catch (Exception unexpectedSomething) {
            throw new ConnectionCheckedException(OCFErrorCode.INVALID_CONNECTOR_PROVIDER.getMessageDefinition(connectorProviderClassName, connectionName, unexpectedSomething.getClass().getName(), unexpectedSomething.getMessage()), this.getClass().getName(), methodName, unexpectedSomething);
        }
        return connectorProvider;
    }

    private ConnectionProperties getConnection(EmbeddedConnectionProperties embeddedConnection) {
        if (embeddedConnection != null) {
            ConnectionProperties accessibleConnection;
            ConnectionProperties connectionProperties = embeddedConnection.getConnectionProperties();
            if (connectionProperties instanceof VirtualConnectionProperties) {
                VirtualConnectionProperties virtualConnectionProperties = (VirtualConnectionProperties)connectionProperties;
                accessibleConnection = new AccessibleVirtualConnection(virtualConnectionProperties);
                VirtualConnection connectionBean = ((AccessibleVirtualConnection)accessibleConnection).getConnectionBean();
                connectionBean.setConfigurationProperties(this.addArgumentsToConfigurationProperties(embeddedConnection.getArguments(), connectionBean.getConfigurationProperties()));
                return new VirtualConnectionProperties(connectionBean);
            }
            accessibleConnection = new AccessibleConnection(embeddedConnection.getConnectionProperties());
            Connection connectionBean = ((AccessibleConnection)accessibleConnection).getConnectionBean();
            connectionBean.setConfigurationProperties(this.addArgumentsToConfigurationProperties(embeddedConnection.getArguments(), connectionBean.getConfigurationProperties()));
            return new ConnectionProperties(connectionBean);
        }
        return null;
    }

    private Map<String, Object> addArgumentsToConfigurationProperties(Map<String, Object> arguments, Map<String, Object> configurationProperties) {
        if (configurationProperties == null) {
            configurationProperties = new HashMap<String, Object>();
        }
        if (arguments != null) {
            for (String argumentName : arguments.keySet()) {
                configurationProperties.put(argumentName, arguments.get(argumentName).toString());
            }
        }
        if (configurationProperties.isEmpty()) {
            configurationProperties = null;
        }
        return configurationProperties;
    }

    public void validateConnection(Connection connection) throws ConnectionCheckedException {
        if (connection == null) {
            this.validateConnection((ConnectionProperties)null);
        } else {
            this.validateConnection(new ConnectionProperties(connection));
        }
    }

    public void validateConnection(ConnectionProperties connection) throws ConnectionCheckedException {
        String methodName = "validateConnection";
        log.debug("==> ConnectorBroker.validateConnection");
        this.validateConnectionNotNull(connection);
        ConnectorTypeProperties requestedConnectorType = this.getConnectorType(connection, "validateConnection");
        this.getConnectorProvider(requestedConnectorType, connection.getConnectionName(), "validateConnection");
        log.debug("<== ConnectorBroker.validateConnection");
    }

    public Connector getConnector(Connection connection) throws ConnectionCheckedException, ConnectorCheckedException {
        if (connection == null) {
            return this.getConnector((ConnectionProperties)null);
        }
        if (connection instanceof VirtualConnection) {
            return this.getConnector(new VirtualConnectionProperties((VirtualConnection)connection));
        }
        return this.getConnector(new ConnectionProperties(connection));
    }

    public Connector getConnector(ConnectionProperties connection) throws ConnectionCheckedException, ConnectorCheckedException {
        Connector connectorInstance;
        String methodName = "getConnector";
        log.debug("==> ConnectorBroker.getConnector");
        this.validateConnection(connection);
        String connectionName = connection.getConnectionName();
        ConnectorTypeProperties requestedConnectorType = this.getConnectorType(connection, "getConnector");
        ConnectorProvider connectorProvider = this.getConnectorProvider(requestedConnectorType, connectionName, "getConnector");
        if (connectorProvider instanceof AuditLoggingComponent) {
            ((AuditLoggingComponent)connectorProvider).setAuditLog(this.auditLog);
        }
        ArrayList<Connector> embeddedConnectors = new ArrayList<Connector>();
        ConnectionProperties processedConnection = connection;
        HashMap<String, SecretsStoreConnector> secretsStoreConnectorMap = new HashMap<String, SecretsStoreConnector>();
        if (connection instanceof VirtualConnectionProperties) {
            VirtualConnectionProperties virtualConnectionProperties = (VirtualConnectionProperties)connection;
            AccessibleConnection accessibleConnection = new AccessibleConnection(connection);
            Connection connectionBean = accessibleConnection.getConnectionBean();
            processedConnection = accessibleConnection;
            log.debug("Creating embedded connectors for connection name: " + connectionName);
            List<EmbeddedConnectionProperties> embeddedConnections = virtualConnectionProperties.getEmbeddedConnections();
            for (EmbeddedConnectionProperties embeddedConnection : embeddedConnections) {
                Connector embeddedConnector = this.getConnector(this.getConnection(embeddedConnection));
                if (embeddedConnector instanceof SecretsStoreConnector) {
                    SecretsStoreConnector secretsStoreConnector = (SecretsStoreConnector)embeddedConnector;
                    secretsStoreConnector.start();
                    if (connectionBean.getUserId() == null) {
                        connectionBean.setUserId(secretsStoreConnector.getSecret(SecretsStoreCollectionProperty.USER_ID.getName()));
                        if (connectionBean.getUserId() == null && connection.getSecuredProperties() != null && connection.getSecuredProperties().get(SecretsStoreCollectionProperty.USER_ID.getName()) != null) {
                            connectionBean.setUserId(secretsStoreConnector.getSecret(connection.getSecuredProperties().get(SecretsStoreCollectionProperty.USER_ID.getName())));
                        }
                    }
                    if (connection.getClearPassword() == null) {
                        connectionBean.setClearPassword(secretsStoreConnector.getSecret(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName()));
                        if (connectionBean.getClearPassword() == null && connection.getSecuredProperties() != null && connection.getSecuredProperties().get(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName()) != null) {
                            connectionBean.setClearPassword(secretsStoreConnector.getSecret(connection.getSecuredProperties().get(SecretsStoreCollectionProperty.CLEAR_PASSWORD.getName())));
                        }
                    }
                    if (connection.getEncryptedPassword() == null) {
                        connectionBean.setEncryptedPassword(secretsStoreConnector.getSecret(SecretsStoreCollectionProperty.ENCRYPTED_PASSWORD.getName()));
                        if (connectionBean.getEncryptedPassword() == null && connection.getSecuredProperties() != null && connection.getSecuredProperties().get(SecretsStoreCollectionProperty.ENCRYPTED_PASSWORD.getName()) != null) {
                            connectionBean.setEncryptedPassword(secretsStoreConnector.getSecret(connection.getSecuredProperties().get(SecretsStoreCollectionProperty.ENCRYPTED_PASSWORD.getName())));
                        }
                    }
                    if (embeddedConnection.getDisplayName() != null) {
                        secretsStoreConnectorMap.put(embeddedConnection.getDisplayName(), secretsStoreConnector);
                    } else {
                        secretsStoreConnectorMap.put(String.valueOf(secretsStoreConnectorMap.size()), secretsStoreConnector);
                    }
                }
                embeddedConnectors.add(embeddedConnector);
            }
        }
        try {
            connectorInstance = connectorProvider.getConnector(processedConnection);
        }
        catch (ConnectionCheckedException | ConnectorCheckedException ocfError) {
            throw ocfError;
        }
        catch (Exception unexpectedSomething) {
            throw new ConnectorCheckedException(OCFErrorCode.CAUGHT_EXCEPTION.getMessageDefinition(), this.getClass().getName(), "getConnector", unexpectedSomething);
        }
        if (connectorInstance == null) {
            throw new OCFRuntimeException(OCFErrorCode.NULL_CONNECTOR.getMessageDefinition(requestedConnectorType.getConnectorProviderClassName(), connection.getConnectionName()), this.getClass().getName(), "getConnector");
        }
        if (connectorInstance instanceof VirtualConnectorExtension) {
            VirtualConnectorExtension virtualConnectorExtension = (VirtualConnectorExtension)((Object)connectorInstance);
            virtualConnectorExtension.initializeEmbeddedConnectors(embeddedConnectors);
        }
        if (connectorInstance instanceof SecureConnectorExtension) {
            SecureConnectorExtension secureConnectorExtension = (SecureConnectorExtension)((Object)connectorInstance);
            for (String displayName : secretsStoreConnectorMap.keySet()) {
                secureConnectorExtension.initializeSecretsStoreConnector(displayName, (SecretsStoreConnector)secretsStoreConnectorMap.get(displayName));
            }
        }
        log.debug("New connector returned: " + connectorInstance.getConnectorInstanceId());
        log.debug("Using Connection: " + connectorInstance.getConnection().getQualifiedName() + "(" + connectorInstance.getConnection().getDisplayName() + ")");
        log.debug("<== ConnectorBroker.getConnector");
        return connectorInstance;
    }

    public String toString() {
        return "ConnectorBroker{}";
    }

    private static class AccessibleVirtualConnection
    extends VirtualConnectionProperties {
        AccessibleVirtualConnection(VirtualConnectionProperties templateConnection) {
            super(templateConnection);
        }

        @Override
        protected VirtualConnection getConnectionBean() {
            return super.getConnectionBean();
        }
    }

    private static class AccessibleConnection
    extends ConnectionProperties {
        AccessibleConnection(ConnectionProperties templateConnection) {
            super(templateConnection);
        }

        @Override
        protected Connection getConnectionBean() {
            return super.getConnectionBean();
        }
    }
}

