/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import org.odpi.openmetadata.frameworks.connectors.ConnectorProviderBase;
import org.odpi.openmetadata.frameworks.connectors.IsolatedConnectorClassLoader;

public class IsolatedConnectorProviderBase
extends ConnectorProviderBase {
    @Override
    protected Class<?> getClassForConnector() throws ClassNotFoundException {
        try {
            IsolatedConnectorClassLoader isolatedConnectorClassLoader = new IsolatedConnectorClassLoader(this.getJARFileURL(this.getClass()));
            return isolatedConnectorClassLoader.loadClass(this.getConnectorClassName());
        }
        catch (IOException error) {
            throw new ClassNotFoundException("Bad provider class name", error);
        }
    }

    private String getJARFileURL(Class<?> providerClass) throws MalformedURLException {
        URL qualifiedClassURL = providerClass.getResource(providerClass.getSimpleName() + ".class");
        if (qualifiedClassURL != null) {
            String qualifiedClassName = qualifiedClassURL.toString();
            String noClassQualifiedName = qualifiedClassName.split("!")[0];
            String[] noJarQualifiedNameSplit = noClassQualifiedName.split("jar:file:");
            String noJarQualifiedName = noJarQualifiedNameSplit[noJarQualifiedNameSplit.length - 1];
            return noJarQualifiedName;
        }
        return null;
    }

    private String getMyJARFilePath() {
        try {
            return this.byGetProtectionDomain(this.getClass());
        }
        catch (Exception exception) {
            return this.byGetResource(this.getClass());
        }
    }

    String byGetProtectionDomain(Class<?> providerClass) throws URISyntaxException {
        URL url = providerClass.getProtectionDomain().getCodeSource().getLocation();
        return Paths.get(url.toURI()).toString();
    }

    String byGetResource(Class<?> providerClass) {
        URL classResource = providerClass.getResource(providerClass.getSimpleName() + ".class");
        if (classResource == null) {
            throw new RuntimeException("class resource is null");
        }
        String url = classResource.toString();
        if (url.startsWith("jar:file:")) {
            String path = url.replaceAll("^jar:(file:.*[.]jar)!/.*", "$1");
            try {
                return Paths.get(new URI(path)).toString();
            }
            catch (Exception error) {
                throw new RuntimeException("Invalid Jar File URL String", error);
            }
        }
        throw new RuntimeException("Invalid Jar File URL String");
    }
}

