/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.controls.TemplateType;

public enum TemplateTypeEnum {
    EXAMPLE("exampleTemplateName", "Supply the qualified name of the template that the ", "Asset", false, null, null);

    private final String templateName;
    private final String templateDescription;
    private final String typeName;
    private final boolean required;
    private final String defaultTemplateGUID;
    private final Map<String, String> otherPropertyValues;

    private TemplateTypeEnum(String templateName, String templateDescription, String typeName, boolean required, String defaultTemplateGUID, Map<String, String> otherPropertyValues) {
        this.templateName = templateName;
        this.templateDescription = templateDescription;
        this.typeName = typeName;
        this.required = required;
        this.defaultTemplateGUID = defaultTemplateGUID;
        this.otherPropertyValues = otherPropertyValues;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getTemplateDescription() {
        return this.templateDescription;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public boolean getRequired() {
        return this.required;
    }

    public String getDefaultTemplateGUID() {
        return this.defaultTemplateGUID;
    }

    public Map<String, String> getOtherPropertyValues() {
        return this.otherPropertyValues;
    }

    public static List<TemplateType> getTemplateTypes() {
        ArrayList<TemplateType> templateTypes = new ArrayList<TemplateType>();
        for (TemplateTypeEnum templateTypeEnum : TemplateTypeEnum.values()) {
            templateTypes.add(templateTypeEnum.getTemplateType());
        }
        return templateTypes;
    }

    public TemplateType getTemplateType() {
        TemplateType templateType = new TemplateType();
        templateType.setTemplateName(this.templateName);
        templateType.setTypeName(this.typeName);
        templateType.setTemplateDescription(this.templateDescription);
        templateType.setRequired(this.required);
        templateType.setDefaultTemplateGUID(this.defaultTemplateGUID);
        templateType.setOtherPropertyValues(this.otherPropertyValues);
        return templateType;
    }

    public String toString() {
        return "TemplateType{templateName='" + this.templateName + "'}";
    }
}

