/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties;

import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetReferenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectorTypeDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.VirtualConnectionDetails;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;

public class ConnectionDetails
extends AssetReferenceable {
    protected Connection connectionBean;

    public ConnectionDetails(Connection connectionBean) {
        super(connectionBean);
        this.connectionBean = connectionBean == null ? new Connection() : connectionBean;
    }

    public ConnectionDetails(ConnectionDetails templateConnection) {
        super(templateConnection);
        if (templateConnection == null) {
            this.connectionBean = new Connection();
        } else if (templateConnection instanceof VirtualConnectionDetails) {
            VirtualConnectionDetails virtualConnectionDetails = (VirtualConnectionDetails)templateConnection;
            this.connectionBean = new VirtualConnection(virtualConnectionDetails.getConnectionBean());
        } else {
            this.connectionBean = new Connection(templateConnection.getConnectionBean());
        }
    }

    public ConnectionDetails(ConnectionDetails templateConnection, ConnectorType connectorType) {
        super(templateConnection);
        if (templateConnection == null) {
            this.connectionBean = new Connection();
        } else if (templateConnection instanceof VirtualConnectionDetails) {
            VirtualConnectionDetails virtualConnectionDetails = (VirtualConnectionDetails)templateConnection;
            this.connectionBean = new VirtualConnection(virtualConnectionDetails.getConnectionBean());
        } else {
            this.connectionBean = new Connection(templateConnection.getConnectionBean());
        }
        this.connectionBean.setConnectorType(connectorType);
    }

    public ConnectionDetails(ConnectionDetails templateConnection, String networkAddress) {
        super(templateConnection);
        if (templateConnection == null) {
            this.connectionBean = new Connection();
        } else if (templateConnection instanceof VirtualConnectionDetails) {
            VirtualConnectionDetails virtualConnectionDetails = (VirtualConnectionDetails)templateConnection;
            this.connectionBean = new VirtualConnection(virtualConnectionDetails.getConnectionBean());
        } else {
            this.connectionBean = new Connection(templateConnection.getConnectionBean());
        }
        Endpoint endpoint = this.getEndpoint().getEndpointBean();
        if (endpoint == null) {
            endpoint = new Endpoint();
        }
        endpoint.setAddress(networkAddress);
        this.connectionBean.setEndpoint(endpoint);
    }

    protected Connection getConnectionBean() {
        return this.connectionBean;
    }

    public String getDisplayName() {
        return this.connectionBean.getDisplayName();
    }

    public String getConnectionName() {
        String connectionName = "<Unknown>";
        String qualifiedName = this.connectionBean.getQualifiedName();
        String displayName = this.connectionBean.getDisplayName();
        if (qualifiedName != null && !qualifiedName.isEmpty()) {
            connectionName = qualifiedName;
        } else if (displayName != null && !displayName.isEmpty()) {
            connectionName = displayName;
        }
        return connectionName;
    }

    public String getDescription() {
        return this.connectionBean.getDescription();
    }

    public ConnectorTypeDetails getConnectorType() {
        ConnectorType connectorType = this.connectionBean.getConnectorType();
        if (connectorType == null) {
            return null;
        }
        return new ConnectorTypeDetails(connectorType);
    }

    public String getUserId() {
        return this.connectionBean.getUserId();
    }

    public String getEncryptedPassword() {
        return this.connectionBean.getEncryptedPassword();
    }

    public String getClearPassword() {
        return this.connectionBean.getClearPassword();
    }

    public EndpointDetails getEndpoint() {
        Endpoint endpoint = this.connectionBean.getEndpoint();
        if (endpoint == null) {
            return null;
        }
        return new EndpointDetails(endpoint);
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.connectionBean.getConfigurationProperties();
    }

    public Map<String, String> getSecuredProperties() {
        return this.connectionBean.getSecuredProperties();
    }

    @Override
    public String toString() {
        return this.connectionBean.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ConnectionDetails that = (ConnectionDetails)objectToCompare;
        return Objects.equals((Object)this.connectionBean, (Object)that.connectionBean);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.connectionBean});
    }
}

