/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.connectors.properties.beans;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Referenceable;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=VirtualConnection.class, name="VirtualConnection")})
public class Connection
extends Referenceable {
    private String displayName = null;
    private String description = null;
    private ConnectorType connectorType = null;
    private Endpoint endpoint = null;
    private String userId = null;
    private String encryptedPassword = null;
    private String clearPassword = null;
    private Map<String, Object> configurationProperties = null;
    private Map<String, String> securedProperties = null;

    public static ElementType getConnectionType() {
        long elementTypeVersion = 1L;
        ElementType elementType = new ElementType();
        elementType.setTypeId(OpenMetadataType.CONNECTION.typeGUID);
        elementType.setTypeName(OpenMetadataType.CONNECTION.typeName);
        elementType.setTypeVersion(1L);
        elementType.setTypeDescription(OpenMetadataType.CONNECTION.description);
        return elementType;
    }

    public Connection() {
    }

    public Connection(Connection template) {
        super(template);
        if (template != null) {
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.userId = template.getUserId();
            this.clearPassword = template.getClearPassword();
            this.encryptedPassword = template.getEncryptedPassword();
            this.connectorType = template.getConnectorType();
            this.endpoint = template.getEndpoint();
            this.configurationProperties = template.getConfigurationProperties();
            this.securedProperties = template.getSecuredProperties();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setConnectorType(ConnectorType connectorType) {
        this.connectorType = connectorType;
    }

    public ConnectorType getConnectorType() {
        return this.connectorType;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    public String getClearPassword() {
        return this.clearPassword;
    }

    public void setClearPassword(String clearPassword) {
        this.clearPassword = clearPassword;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setConfigurationProperties(Map<String, Object> configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public Map<String, Object> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setSecuredProperties(Map<String, String> securedProperties) {
        this.securedProperties = securedProperties;
    }

    public Map<String, String> getSecuredProperties() {
        return this.securedProperties;
    }

    @Override
    public String toString() {
        return "Connection{displayName='" + this.displayName + "', description='" + this.description + "', connectorType=" + String.valueOf((Object)this.connectorType) + ", endpoint=" + String.valueOf((Object)this.endpoint) + ", userId='" + this.userId + "', encryptedPassword='" + this.encryptedPassword + "', clearPassword='" + this.clearPassword + "', configurationProperties=" + String.valueOf(this.configurationProperties) + ", securedProperties=" + String.valueOf(this.securedProperties) + "} " + super.toString();
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        Connection that = (Connection)((Object)objectToCompare);
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals((Object)this.getConnectorType(), (Object)that.getConnectorType()) && Objects.equals((Object)this.getEndpoint(), (Object)that.getEndpoint()) && Objects.equals(this.getUserId(), that.getUserId()) && Objects.equals(this.getEncryptedPassword(), that.getEncryptedPassword()) && Objects.equals(this.getClearPassword(), that.getClearPassword()) && Objects.equals(this.getConfigurationProperties(), that.getConfigurationProperties()) && Objects.equals(this.getSecuredProperties(), that.getSecuredProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getDisplayName(), this.getDescription(), this.getConnectorType(), this.getEndpoint(), this.getUserId(), this.getEncryptedPassword(), this.getClearPassword(), this.getSecuredProperties(), this.getConfigurationProperties()});
    }
}

