/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryServiceException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.ODFErrorCode;

public class DiscoveryPipeline
extends DiscoveryService
implements VirtualConnectorExtension {
    protected List<Connector> embeddedConnectors = null;
    protected List<DiscoveryService> embeddedDiscoveryServices = null;

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    private List<DiscoveryService> getEmbeddedDiscoveryServices(List<Connector> embeddedConnectors) throws DiscoveryServiceException {
        String methodName = "getEmbeddedDiscoveryServices";
        ArrayList<DiscoveryService> discoveryServices = null;
        if (embeddedConnectors != null) {
            discoveryServices = new ArrayList<DiscoveryService>();
            for (Connector embeddedConnector : embeddedConnectors) {
                if (embeddedConnector == null) continue;
                if (embeddedConnector instanceof DiscoveryService) {
                    discoveryServices.add((DiscoveryService)embeddedConnector);
                    continue;
                }
                ODFErrorCode errorCode = ODFErrorCode.INVALID_EMBEDDED_DISCOVERY_SERVICE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName);
                throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEmbeddedDiscoveryServices", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (discoveryServices.isEmpty()) {
                discoveryServices = null;
            }
        }
        return discoveryServices;
    }

    @Override
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        this.embeddedDiscoveryServices = this.getEmbeddedDiscoveryServices(this.embeddedConnectors);
        if (this.embeddedDiscoveryServices == null) {
            ODFErrorCode errorCode = ODFErrorCode.NO_EMBEDDED_DISCOVERY_SERVICES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName);
            throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "start", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        for (DiscoveryService discoveryService : this.embeddedDiscoveryServices) {
            if (discoveryService == null) continue;
            discoveryService.setDiscoveryContext(this.discoveryContext);
            discoveryService.start();
            discoveryService.disconnect();
        }
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

