/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryServiceException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.ODFErrorCode;

public abstract class DiscoveryService
extends ConnectorBase {
    protected String discoveryServiceName = "<Unknown>";
    protected DiscoveryContext discoveryContext = null;

    public synchronized void setDiscoveryContext(DiscoveryContext discoveryContext) {
        this.discoveryContext = discoveryContext;
    }

    public void setDiscoveryServiceName(String discoveryServiceName) {
        this.discoveryServiceName = discoveryServiceName;
    }

    public synchronized DiscoveryContext getDiscoveryContext() {
        return this.discoveryContext;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        if (this.discoveryContext == null) {
            String methodName = "start";
            ODFErrorCode errorCode = ODFErrorCode.NULL_DISCOVERY_CONTEXT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName);
            throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "start", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    protected void handleUnexpectedException(String methodName, Throwable error) throws ConnectorCheckedException {
        ODFErrorCode errorCode = ODFErrorCode.UNEXPECTED_EXCEPTION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName, error.getClass().getName(), methodName, error.getMessage());
        throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

