/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectionCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;

public abstract class DiscoveryAssetStore {
    protected String assetGUID;
    protected String userId;
    protected Connection assetConnection = null;

    public DiscoveryAssetStore(String assetGUID, String userId) {
        this.assetGUID = assetGUID;
        this.userId = userId;
    }

    public String getAssetGUID() {
        return this.assetGUID;
    }

    protected abstract Connector getConnectorByConnection(Connection var1) throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException;

    protected abstract Connection getConnectionForAsset() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException;

    public abstract AssetUniverse getAssetProperties() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException;

    public abstract void logAssetAuditMessage(String var1) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException;

    public Connector getConnectorToAsset() throws InvalidParameterException, ConnectionCheckedException, ConnectorCheckedException, UserNotAuthorizedException, PropertyServerException {
        if (this.assetConnection == null) {
            this.assetConnection = this.getConnectionForAsset();
        }
        return this.getConnectorByConnection(this.assetConnection);
    }
}

