/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetStore;

public class DiscoveryContext
extends PropertyBase {
    protected String userId;
    protected String assetGUID;
    protected String discoveryReportGUID;
    protected Map<String, String> analysisParameters;
    protected List<String> requestedAnnotationTypes;
    protected DiscoveryAssetStore assetStore;
    protected DiscoveryAnnotationStore annotationStore;
    protected Date creationDate = new Date();
    protected String reportQualifiedName = null;
    protected String reportDisplayName = null;
    protected String reportDescription = null;

    public DiscoveryContext(String userId, String assetGUID, String discoveryReportGUID, Map<String, String> analysisParameters, List<String> requestedAnnotationTypes, DiscoveryAssetStore assetStore, DiscoveryAnnotationStore annotationStore) {
        this.userId = userId;
        this.assetGUID = assetGUID;
        this.discoveryReportGUID = discoveryReportGUID;
        this.analysisParameters = analysisParameters;
        this.requestedAnnotationTypes = requestedAnnotationTypes;
        this.assetStore = assetStore;
        this.annotationStore = annotationStore;
    }

    public DiscoveryContext(DiscoveryContext template) {
        super((PropertyBase)template);
        if (template != null) {
            this.userId = template.userId;
            this.assetGUID = template.getAssetGUID();
            this.discoveryReportGUID = template.getDiscoveryReportGUID();
            this.analysisParameters = template.getAnalysisParameters();
            this.requestedAnnotationTypes = template.getRequestedAnnotationTypes();
            this.assetStore = template.getAssetStore();
            this.annotationStore = template.getAnnotationStore();
            this.creationDate = template.getCreationDate();
            this.reportQualifiedName = template.getReportQualifiedName();
            this.reportDisplayName = template.getReportDisplayName();
            this.reportDescription = template.getReportDescription();
        }
    }

    public String getAssetGUID() {
        return this.assetGUID;
    }

    public String getDiscoveryReportGUID() {
        return this.discoveryReportGUID;
    }

    public Map<String, String> getAnalysisParameters() {
        return this.analysisParameters;
    }

    public List<String> getRequestedAnnotationTypes() {
        return this.requestedAnnotationTypes;
    }

    public DiscoveryAssetStore getAssetStore() {
        return this.assetStore;
    }

    public DiscoveryAnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getReportQualifiedName() {
        return this.reportQualifiedName;
    }

    public void setReportQualifiedName(String reportName) {
        this.reportQualifiedName = reportName;
    }

    public String getReportDisplayName() {
        return this.reportDisplayName;
    }

    public void setReportDisplayName(String reportName) {
        this.reportDisplayName = reportName;
    }

    public String getReportDescription() {
        return this.reportDescription;
    }

    public void setReportDescription(String reportDescription) {
        this.reportDescription = reportDescription;
    }

    public String toString() {
        return "DiscoveryContext{userId='" + this.userId + '\'' + ", assetGUID='" + this.assetGUID + '\'' + ", discoveryReportGUID='" + this.discoveryReportGUID + '\'' + ", analysisParameters=" + this.analysisParameters + ", requestedAnnotationTypes=" + this.requestedAnnotationTypes + ", assetStore=" + this.assetStore + ", annotationStore=" + this.annotationStore + ", creationDate=" + this.creationDate + ", reportQualifiedName='" + this.reportQualifiedName + '\'' + ", reportDisplayName='" + this.reportDisplayName + '\'' + ", reportDescription='" + this.reportDescription + '\'' + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        DiscoveryContext that = (DiscoveryContext)((Object)objectToCompare);
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.getAssetGUID(), that.getAssetGUID()) && Objects.equals(this.getDiscoveryReportGUID(), that.getDiscoveryReportGUID()) && Objects.equals(this.getAnalysisParameters(), that.getAnalysisParameters()) && Objects.equals(this.getRequestedAnnotationTypes(), that.getRequestedAnnotationTypes()) && Objects.equals(this.getAssetStore(), that.getAssetStore()) && Objects.equals(this.getAnnotationStore(), that.getAnnotationStore()) && Objects.equals(this.getCreationDate(), that.getCreationDate()) && Objects.equals(this.getReportQualifiedName(), that.getReportQualifiedName()) && Objects.equals(this.getReportDisplayName(), that.getReportDisplayName()) && Objects.equals(this.getReportDescription(), that.getReportDescription());
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.getAssetGUID(), this.getDiscoveryReportGUID(), this.getAnalysisParameters(), this.getRequestedAnnotationTypes(), this.getAssetStore(), this.getAnnotationStore(), this.getCreationDate(), this.getReportQualifiedName(), this.getReportDisplayName(), this.getReportDescription());
    }
}

