/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.PropertyBase;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAnnotationStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetCatalogStore;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryAssetStore;

public class DiscoveryContext
extends PropertyBase {
    private String userId;
    private String assetGUID;
    private Map<String, String> analysisParameters;
    private List<String> requestedAnnotationTypes;
    private DiscoveryAssetStore assetStore;
    private DiscoveryAnnotationStore annotationStore;
    private DiscoveryAssetCatalogStore assetCatalogStore;

    public DiscoveryContext(String userId, String assetGUID, Map<String, String> analysisParameters, List<String> requestedAnnotationTypes, DiscoveryAssetStore assetStore, DiscoveryAnnotationStore annotationStore, DiscoveryAssetCatalogStore assetCatalogStore) {
        this.userId = userId;
        this.assetGUID = assetGUID;
        this.analysisParameters = analysisParameters;
        this.requestedAnnotationTypes = requestedAnnotationTypes;
        this.assetStore = assetStore;
        this.annotationStore = annotationStore;
        this.assetCatalogStore = assetCatalogStore;
    }

    public DiscoveryContext(DiscoveryContext template) {
        super((PropertyBase)template);
        if (template != null) {
            this.userId = template.userId;
            this.assetGUID = template.getAssetGUID();
            this.analysisParameters = template.getAnalysisParameters();
            this.requestedAnnotationTypes = template.getRequestedAnnotationTypes();
            this.assetStore = template.getAssetStore();
            this.annotationStore = template.getAnnotationStore();
            this.assetCatalogStore = template.getAssetCatalogStore();
        }
    }

    public String getAssetGUID() {
        return this.assetGUID;
    }

    public Map<String, String> getAnalysisParameters() {
        return this.analysisParameters;
    }

    public List<String> getRequestedAnnotationTypes() {
        return this.requestedAnnotationTypes;
    }

    public DiscoveryAssetCatalogStore getAssetCatalogStore() {
        return this.assetCatalogStore;
    }

    public DiscoveryAssetStore getAssetStore() {
        return this.assetStore;
    }

    public DiscoveryAnnotationStore getAnnotationStore() {
        return this.annotationStore;
    }

    public String toString() {
        return "DiscoveryContext{userId='" + this.userId + '\'' + ", assetGUID='" + this.assetGUID + '\'' + ", analysisParameters=" + this.analysisParameters + ", requestedAnnotationTypes=" + this.requestedAnnotationTypes + ", assetStore=" + this.assetStore + ", annotationStore=" + this.annotationStore + ", assetCatalogStore=" + this.assetCatalogStore + '}';
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        DiscoveryContext that = (DiscoveryContext)((Object)objectToCompare);
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.getAssetGUID(), that.getAssetGUID()) && Objects.equals(this.getAnalysisParameters(), that.getAnalysisParameters()) && Objects.equals(this.getRequestedAnnotationTypes(), that.getRequestedAnnotationTypes());
    }

    public int hashCode() {
        return Objects.hash(this.userId, this.getAssetGUID(), this.getAnalysisParameters(), this.getRequestedAnnotationTypes());
    }
}

