/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryServiceException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.ODFErrorCode;

public abstract class DiscoveryPipeline
extends DiscoveryService
implements VirtualConnectorExtension {
    protected List<Connector> embeddedConnectors = null;
    protected List<DiscoveryService> embeddedDiscoveryServices = null;

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    @Override
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        this.embeddedDiscoveryServices = this.getEmbeddedDiscoveryServices(this.embeddedConnectors);
        if (this.embeddedDiscoveryServices == null) {
            ODFErrorCode errorCode = ODFErrorCode.NO_EMBEDDED_DISCOVERY_SERVICES;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName);
            throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "start", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
        this.runDiscoveryPipeline();
    }

    protected abstract void runDiscoveryPipeline() throws ConnectorCheckedException;

    @Override
    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

