/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum DiscoveryRequestStatus implements Serializable
{
    WAITING(0, "Waiting", "Discovery request is waiting to execute in the discovery engine"),
    ACTIVATING(1, "Activating", "Discovery request is being initialized in the discovery engine"),
    IN_PROGRESS(2, "In Progress", "Discovery request is executing"),
    FAILED(3, "Failed", "Discovery request has failed"),
    COMPLETED(4, "Completed", "Discovery request has completed successfully"),
    UNKNOWN_STATUS(99, "Unknown", "Discovery request status is unknown");

    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String statusName;
    private String statusDescription;

    private DiscoveryRequestStatus(int statusCode, String statusName, String statusDescription) {
        this.statusCode = statusCode;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getOrdinal() {
        return this.statusCode;
    }

    public String getName() {
        return this.statusName;
    }

    public String getDescription() {
        return this.statusDescription;
    }

    public String toString() {
        return "DiscoveryRequestStatus{statusCode=" + this.statusCode + ", statusName='" + this.statusName + '\'' + ", statusDescription='" + this.statusDescription + '\'' + '}';
    }
}

