/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DiscoveryServiceProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RegisteredDiscoveryService
extends DiscoveryServiceProperties {
    private static final long serialVersionUID = 1L;
    protected List<String> assetDiscoveryTypes = null;

    public RegisteredDiscoveryService() {
    }

    public RegisteredDiscoveryService(RegisteredDiscoveryService template) {
        super(template);
        if (template != null) {
            this.assetDiscoveryTypes = template.getAssetDiscoveryTypes();
        }
    }

    public RegisteredDiscoveryService(DiscoveryServiceProperties template) {
        super(template);
    }

    public List<String> getAssetDiscoveryTypes() {
        if (this.assetDiscoveryTypes == null) {
            return null;
        }
        if (this.assetDiscoveryTypes.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.assetDiscoveryTypes);
    }

    public void setAssetDiscoveryTypes(List<String> assetDiscoveryTypes) {
        this.assetDiscoveryTypes = assetDiscoveryTypes;
    }

    @Override
    public String toString() {
        return "RegisteredDiscoveryService{assetDiscoveryTypes=" + this.assetDiscoveryTypes + ", displayName='" + this.displayName + '\'' + ", shortDescription='" + this.shortDescription + '\'' + ", description='" + this.description + '\'' + ", owner='" + this.owner + '\'' + ", ownerType=" + this.ownerType + ", zoneMembership=" + this.zoneMembership + ", qualifiedName='" + this.qualifiedName + '\'' + ", additionalProperties=" + this.additionalProperties + ", extendedProperties=" + this.extendedProperties + ", meanings=" + this.meanings + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RegisteredDiscoveryService that = (RegisteredDiscoveryService)((Object)objectToCompare);
        return Objects.equals(this.getAssetDiscoveryTypes(), that.getAssetDiscoveryTypes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getAssetDiscoveryTypes());
    }
}

