/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryServiceException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.ODFErrorCode;

public abstract class DiscoveryService
extends ConnectorBase {
    protected String discoveryServiceName = "<Unknown>";
    protected DiscoveryContext discoveryContext = null;

    public synchronized void setDiscoveryContext(DiscoveryContext discoveryContext) {
        this.discoveryContext = discoveryContext;
    }

    public void setDiscoveryServiceName(String discoveryServiceName) {
        this.discoveryServiceName = discoveryServiceName;
    }

    public synchronized DiscoveryContext getDiscoveryContext() {
        return this.discoveryContext;
    }

    protected List<DiscoveryService> getEmbeddedDiscoveryServices(List<Connector> embeddedConnectors) throws DiscoveryServiceException {
        String methodName = "getEmbeddedDiscoveryServices";
        ArrayList<DiscoveryService> discoveryServices = null;
        if (embeddedConnectors != null) {
            discoveryServices = new ArrayList<DiscoveryService>();
            for (Connector embeddedConnector : embeddedConnectors) {
                if (embeddedConnector == null) continue;
                if (embeddedConnector instanceof DiscoveryService) {
                    discoveryServices.add((DiscoveryService)embeddedConnector);
                    continue;
                }
                ODFErrorCode errorCode = ODFErrorCode.INVALID_EMBEDDED_DISCOVERY_SERVICE;
                String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName);
                throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "getEmbeddedDiscoveryServices", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
            }
            if (discoveryServices.isEmpty()) {
                discoveryServices = null;
            }
        }
        return discoveryServices;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.discoveryContext == null) {
            ODFErrorCode errorCode = ODFErrorCode.NULL_DISCOVERY_CONTEXT;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName);
            throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), "start", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    protected void handleUnexpectedException(String methodName, Throwable error) throws ConnectorCheckedException {
        ODFErrorCode errorCode = ODFErrorCode.UNEXPECTED_EXCEPTION;
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(this.discoveryServiceName, error.getClass().getName(), methodName, error.getMessage());
        throw new DiscoveryServiceException(errorCode.getHTTPErrorCode(), ((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        super.disconnect();
    }
}

