/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryServiceException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.ODFErrorCode;

public abstract class DiscoveryService
extends ConnectorBase {
    protected String discoveryServiceName = "<Unknown>";
    protected DiscoveryContext discoveryContext = null;

    public synchronized void setDiscoveryContext(DiscoveryContext discoveryContext) {
        this.discoveryContext = discoveryContext;
    }

    public void setDiscoveryServiceName(String discoveryServiceName) {
        this.discoveryServiceName = discoveryServiceName;
    }

    public synchronized DiscoveryContext getDiscoveryContext() {
        return this.discoveryContext;
    }

    protected List<DiscoveryService> getEmbeddedDiscoveryServices(List<Connector> embeddedConnectors) throws DiscoveryServiceException {
        String methodName = "getEmbeddedDiscoveryServices";
        ArrayList<DiscoveryService> discoveryServices = null;
        if (embeddedConnectors != null) {
            discoveryServices = new ArrayList<DiscoveryService>();
            for (Connector embeddedConnector : embeddedConnectors) {
                if (embeddedConnector == null) continue;
                if (embeddedConnector instanceof DiscoveryService) {
                    discoveryServices.add((DiscoveryService)embeddedConnector);
                    continue;
                }
                throw new DiscoveryServiceException(ODFErrorCode.INVALID_EMBEDDED_DISCOVERY_SERVICE.getMessageDefinition(this.discoveryServiceName), ((Object)((Object)this)).getClass().getName(), "getEmbeddedDiscoveryServices");
            }
            if (discoveryServices.isEmpty()) {
                discoveryServices = null;
            }
        }
        return discoveryServices;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.discoveryContext == null) {
            throw new DiscoveryServiceException(ODFErrorCode.NULL_DISCOVERY_CONTEXT.getMessageDefinition(this.discoveryServiceName), ((Object)((Object)this)).getClass().getName(), "start");
        }
    }

    protected void handleUnexpectedException(String methodName, Throwable error) throws ConnectorCheckedException {
        throw new DiscoveryServiceException(ODFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.discoveryServiceName, error.getClass().getName(), methodName, error.getMessage()), ((Object)((Object)this)).getClass().getName(), methodName);
    }

    public void disconnect() throws ConnectorCheckedException {
        String methodName = "disconnect";
        super.disconnect();
    }
}

