/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class QualityAnnotation
extends DataFieldAnnotation {
    private static final long serialVersionUID = 1L;
    private String qualityDimension = null;
    private int qualityScore = 0;

    public QualityAnnotation() {
    }

    public QualityAnnotation(QualityAnnotation template) {
        super(template);
        if (template != null) {
            this.qualityDimension = template.getQualityDimension();
            this.qualityScore = template.getQualityScore();
        }
    }

    public String getQualityDimension() {
        return this.qualityDimension;
    }

    public void setQualityDimension(String qualityDimension) {
        this.qualityDimension = qualityDimension;
    }

    public int getQualityScore() {
        return this.qualityScore;
    }

    public void setQualityScore(int qualityScore) {
        this.qualityScore = qualityScore;
    }

    @Override
    public String toString() {
        return "QualityAnnotation{qualityDimension='" + this.qualityDimension + '\'' + ", qualityScore=" + this.qualityScore + ", annotationType='" + this.annotationType + '\'' + ", summary='" + this.summary + '\'' + ", confidenceLevel=" + this.confidenceLevel + ", expression='" + this.expression + '\'' + ", explanation='" + this.explanation + '\'' + ", analysisStep='" + this.analysisStep + '\'' + ", jsonProperties='" + this.jsonProperties + '\'' + ", numAttachedAnnotations=" + this.numAttachedAnnotations + ", annotationStatus=" + this.annotationStatus + ", reviewDate=" + this.reviewDate + ", steward='" + this.steward + '\'' + ", reviewComment='" + this.reviewComment + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + ", extendedProperties=" + this.extendedProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        QualityAnnotation that = (QualityAnnotation)((Object)objectToCompare);
        return this.qualityScore == that.qualityScore && Objects.equals(this.qualityDimension, that.qualityDimension);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.qualityDimension, this.qualityScore);
    }
}

