/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AnnotationStatus implements Serializable
{
    NEW_ANNOTATION(0, "New", "Annotation has been created but not reviewed"),
    REVIEWED_ANNOTATION(1, "Reviewed", "Annotation has been reviewed by no decision has been made"),
    APPROVED_ANNOTATION(2, "Approved", "Annotation has been approved"),
    ACTIONED_ANNOTATION(3, "Actioned", "Annotation has been approved and insight has been added to Asset's metadata"),
    INVALID_ANNOTATION(4, "Invalid", "Annotation has been reviewed and declared invalid"),
    IGNORE_ANNOTATION(5, "Ignore", "Annotation is invalid and should be ignored"),
    OTHER_STATUS(98, "Other", "Annotation's status stored in additional properties"),
    UNKNOWN_STATUS(99, "Unknown", "Annotation has not had a status assigned");

    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String statusName;
    private String statusDescription;

    private AnnotationStatus(int statusCode, String statusName, String statusDescription) {
        this.statusCode = statusCode;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getOrdinal() {
        return this.statusCode;
    }

    public String getName() {
        return this.statusName;
    }

    public String getDescription() {
        return this.statusDescription;
    }

    public String toString() {
        return "AnnotationStatus{statusCode=" + this.statusCode + ", statusName='" + this.statusName + '\'' + ", statusDescription='" + this.statusDescription + '\'' + '}';
    }
}

