/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataProfileAnnotation
extends DataFieldAnnotation {
    private static final long serialVersionUID = 1L;
    private int length = 0;
    private String inferredDataType = null;
    private String inferredFormat = null;
    private int inferredLength = 0;
    private int inferredScale = 0;
    private Map<String, String> profileProperties = null;
    private Map<String, Boolean> profileFlags = null;
    private Map<String, Long> profileCounts = null;
    private List<String> valueList = null;
    private Map<String, Integer> valueCount = null;
    private String valueRangeFrom = null;
    private String valueRangeTo = null;
    private String averageValue = null;

    public DataProfileAnnotation() {
    }

    public DataProfileAnnotation(DataProfileAnnotation template) {
        super(template);
        if (template != null) {
            this.profileProperties = template.getProfileProperties();
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getInferredDataType() {
        return this.inferredDataType;
    }

    public void setInferredDataType(String inferredDataType) {
        this.inferredDataType = inferredDataType;
    }

    public String getInferredFormat() {
        return this.inferredFormat;
    }

    public void setInferredFormat(String inferredFormat) {
        this.inferredFormat = inferredFormat;
    }

    public int getInferredLength() {
        return this.inferredLength;
    }

    public void setInferredLength(int inferredLength) {
        this.inferredLength = inferredLength;
    }

    public int getInferredScale() {
        return this.inferredScale;
    }

    public void setInferredScale(int inferredScale) {
        this.inferredScale = inferredScale;
    }

    public Map<String, String> getProfileProperties() {
        if (this.profileProperties == null) {
            return null;
        }
        if (this.profileProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.profileProperties);
    }

    public void setProfileProperties(Map<String, String> profileProperties) {
        this.profileProperties = profileProperties;
    }

    public Map<String, Boolean> getProfileFlags() {
        if (this.profileFlags == null) {
            return null;
        }
        if (this.profileFlags.isEmpty()) {
            return null;
        }
        return new HashMap<String, Boolean>(this.profileFlags);
    }

    public void setProfileFlags(Map<String, Boolean> profileFlags) {
        this.profileFlags = profileFlags;
    }

    public Map<String, Long> getProfileCounts() {
        if (this.profileCounts == null) {
            return null;
        }
        if (this.profileCounts.isEmpty()) {
            return null;
        }
        return new HashMap<String, Long>(this.profileCounts);
    }

    public void setProfileCounts(Map<String, Long> profileCounts) {
        this.profileCounts = profileCounts;
    }

    public List<String> getValueList() {
        if (this.valueList == null) {
            return null;
        }
        if (this.valueList.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.valueList);
    }

    public void setValueList(List<String> valueList) {
        this.valueList = valueList;
    }

    public Map<String, Integer> getValueCount() {
        if (this.valueCount == null) {
            return null;
        }
        if (this.valueCount.isEmpty()) {
            return null;
        }
        return new HashMap<String, Integer>(this.valueCount);
    }

    public void setValueCount(Map<String, Integer> valueCount) {
        this.valueCount = valueCount;
    }

    public String getValueRangeFrom() {
        return this.valueRangeFrom;
    }

    public void setValueRangeFrom(String valueRangeFrom) {
        this.valueRangeFrom = valueRangeFrom;
    }

    public String getValueRangeTo() {
        return this.valueRangeTo;
    }

    public void setValueRangeTo(String valueRangeTo) {
        this.valueRangeTo = valueRangeTo;
    }

    public String getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(String averageValue) {
        this.averageValue = averageValue;
    }

    @Override
    public String toString() {
        return "DataProfileAnnotation{length=" + this.length + ", inferredDataType='" + this.inferredDataType + '\'' + ", inferredFormat='" + this.inferredFormat + '\'' + ", inferredLength=" + this.inferredLength + ", inferredScale=" + this.inferredScale + ", profileProperties=" + this.profileProperties + ", profileFlags=" + this.profileFlags + ", profileCounts=" + this.profileCounts + ", valueList=" + this.valueList + ", valueCount=" + this.valueCount + ", valueRangeFrom='" + this.valueRangeFrom + '\'' + ", valueRangeTo='" + this.valueRangeTo + '\'' + ", averageValue='" + this.averageValue + '\'' + ", annotationType='" + this.getAnnotationType() + '\'' + ", summary='" + this.getSummary() + '\'' + ", confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + '\'' + ", explanation='" + this.getExplanation() + '\'' + ", analysisStep='" + this.getAnalysisStep() + '\'' + ", jsonProperties='" + this.getJsonProperties() + '\'' + ", annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + '\'' + ", reviewComment='" + this.getReviewComment() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataProfileAnnotation that = (DataProfileAnnotation)((Object)objectToCompare);
        return this.getLength() == that.getLength() && this.getInferredLength() == that.getInferredLength() && this.getInferredScale() == that.getInferredScale() && Objects.equals(this.getInferredDataType(), that.getInferredDataType()) && Objects.equals(this.getInferredFormat(), that.getInferredFormat()) && Objects.equals(this.getProfileProperties(), that.getProfileProperties()) && Objects.equals(this.getProfileFlags(), that.getProfileFlags()) && Objects.equals(this.getProfileCounts(), that.getProfileCounts()) && Objects.equals(this.getValueList(), that.getValueList()) && Objects.equals(this.getValueCount(), that.getValueCount()) && Objects.equals(this.getValueRangeFrom(), that.getValueRangeFrom()) && Objects.equals(this.getValueRangeTo(), that.getValueRangeTo()) && Objects.equals(this.getAverageValue(), that.getAverageValue());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getLength(), this.getInferredDataType(), this.getInferredFormat(), this.getInferredLength(), this.getInferredScale(), this.getProfileProperties(), this.getProfileFlags(), this.getProfileCounts(), this.getValueList(), this.getValueCount(), this.getValueRangeFrom(), this.getValueRangeTo(), this.getAverageValue());
    }
}

