/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SchemaAnalysisAnnotation
extends Annotation {
    private static final long serialVersionUID = 1L;
    private String schemaName = null;
    private String schemaTypeName = null;
    private int discoveredDataFields = 0;

    public SchemaAnalysisAnnotation() {
    }

    public SchemaAnalysisAnnotation(SchemaAnalysisAnnotation template) {
        super(template);
        if (template != null) {
            this.schemaName = template.getSchemaName();
            this.schemaTypeName = template.getSchemaTypeName();
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getSchemaTypeName() {
        return this.schemaTypeName;
    }

    public void setSchemaTypeName(String schemaTypeName) {
        this.schemaTypeName = schemaTypeName;
    }

    public int getDiscoveredDataFields() {
        return this.discoveredDataFields;
    }

    public void setDiscoveredDataFields(int discoveredDataFields) {
        this.discoveredDataFields = discoveredDataFields;
    }

    @Override
    public String toString() {
        return "SchemaAnalysisAnnotation{schemaName='" + this.schemaName + '\'' + ", schemaTypeName='" + this.schemaTypeName + '\'' + ", discoveredDataFields='" + this.discoveredDataFields + '\'' + ", annotationType='" + this.getAnnotationType() + '\'' + ", summary='" + this.getSummary() + '\'' + ", confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + '\'' + ", explanation='" + this.getExplanation() + '\'' + ", analysisStep='" + this.getAnalysisStep() + '\'' + ", jsonProperties='" + this.getJsonProperties() + '\'' + ", annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", steward='" + this.getSteward() + '\'' + ", reviewComment='" + this.getReviewComment() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", extendedProperties=" + this.getExtendedProperties() + ", type=" + this.getType() + ", GUID='" + this.getGUID() + '\'' + ", URL='" + this.getURL() + '\'' + ", classifications=" + this.getClassifications() + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SchemaAnalysisAnnotation that = (SchemaAnalysisAnnotation)((Object)objectToCompare);
        return this.discoveredDataFields == that.discoveredDataFields && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.schemaTypeName, that.schemaTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSchemaName(), this.getSchemaTypeName(), this.getDiscoveredDataFields());
    }
}

