/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementClassification;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementControlHeader;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementHeader
extends ElementControlHeader {
    private static final long serialVersionUID = 1L;
    private ElementType type = null;
    private String guid = null;
    private String url = null;
    private List<ElementClassification> classifications = null;

    public ElementHeader() {
    }

    public ElementHeader(ElementHeader template) {
        super(template);
        if (template != null) {
            this.type = template.getType();
            this.guid = template.getGUID();
            this.url = template.getURL();
            this.classifications = template.getClassifications();
        }
    }

    public ElementType getType() {
        if (this.type == null) {
            return null;
        }
        return this.type;
    }

    public void setType(ElementType type) {
        this.type = type;
    }

    public String getGUID() {
        return this.guid;
    }

    public void setGUID(String guid) {
        this.guid = guid;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public List<ElementClassification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<ElementClassification>(this.classifications);
    }

    public void setClassifications(List<ElementClassification> classifications) {
        this.classifications = classifications;
    }

    @Override
    public String toString() {
        return "ElementHeader{type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ElementHeader)) {
            return false;
        }
        ElementHeader that = (ElementHeader)objectToCompare;
        return Objects.equals(this.getType(), that.getType()) && Objects.equals(this.guid, that.guid) && Objects.equals(this.url, that.url) && Objects.equals(this.getClassifications(), that.getClassifications());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.type, this.guid, this.url, this.classifications);
    }
}

