/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RequestForActionAnnotation
extends DataFieldAnnotation {
    private static final long serialVersionUID = 1L;
    private String discoveryActivity = null;
    private String actionRequested = null;
    private Map<String, String> actionProperties = null;

    public RequestForActionAnnotation() {
    }

    public RequestForActionAnnotation(RequestForActionAnnotation template) {
        super(template);
        if (template != null) {
            this.discoveryActivity = template.getDiscoveryActivity();
            this.actionRequested = template.getActionRequested();
            this.actionProperties = template.getActionProperties();
        }
    }

    public String getDiscoveryActivity() {
        return this.discoveryActivity;
    }

    public void setDiscoveryActivity(String discoveryActivity) {
        this.discoveryActivity = discoveryActivity;
    }

    public String getActionRequested() {
        return this.actionRequested;
    }

    public void setActionRequested(String actionRequested) {
        this.actionRequested = actionRequested;
    }

    public Map<String, String> getActionProperties() {
        if (this.actionProperties == null) {
            return null;
        }
        if (this.actionProperties.isEmpty()) {
            return null;
        }
        return this.actionProperties;
    }

    public void setActionProperties(Map<String, String> actionProperties) {
        this.actionProperties = actionProperties;
    }

    @Override
    public String toString() {
        return "RequestForActionAnnotation{discoveryActivity='" + this.discoveryActivity + '\'' + ", actionRequested='" + this.actionRequested + '\'' + ", actionProperties=" + this.actionProperties + ", annotationType='" + this.getAnnotationType() + '\'' + ", summary='" + this.getSummary() + '\'' + ", confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + '\'' + ", explanation='" + this.getExplanation() + '\'' + ", analysisStep='" + this.getAnalysisStep() + '\'' + ", jsonProperties='" + this.getJsonProperties() + '\'' + ", annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + '\'' + ", reviewComment='" + this.getReviewComment() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RequestForActionAnnotation that = (RequestForActionAnnotation)objectToCompare;
        return Objects.equals(this.discoveryActivity, that.discoveryActivity) && Objects.equals(this.actionRequested, that.actionRequested) && Objects.equals(this.actionProperties, that.actionProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.discoveryActivity, this.actionRequested, this.actionProperties);
    }
}

