/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SemanticAnnotation
extends DataFieldAnnotation {
    private static final long serialVersionUID = 1L;
    private String informalTerm = null;
    private String informalTopic = null;
    private List<String> candidateGlossaryTermGUIDs = null;
    private List<String> candidateGlossaryCategoryGUIDs = null;

    public SemanticAnnotation() {
    }

    public SemanticAnnotation(SemanticAnnotation template) {
        super(template);
        if (template != null) {
            this.informalTerm = template.getInformalTerm();
            this.informalTopic = template.getInformalTopic();
            this.candidateGlossaryTermGUIDs = template.getCandidateGlossaryTermGUIDs();
            this.candidateGlossaryCategoryGUIDs = template.getCandidateGlossaryCategoryGUIDs();
        }
    }

    public String getInformalTerm() {
        return this.informalTerm;
    }

    public void setInformalTerm(String informalTerm) {
        this.informalTerm = informalTerm;
    }

    public String getInformalTopic() {
        return this.informalTopic;
    }

    public void setInformalTopic(String informalTopic) {
        this.informalTopic = informalTopic;
    }

    public List<String> getCandidateGlossaryTermGUIDs() {
        return this.candidateGlossaryTermGUIDs;
    }

    public void setCandidateGlossaryTermGUIDs(List<String> candidateGlossaryTermGUIDs) {
        this.candidateGlossaryTermGUIDs = candidateGlossaryTermGUIDs;
    }

    public List<String> getCandidateGlossaryCategoryGUIDs() {
        return this.candidateGlossaryCategoryGUIDs;
    }

    public void setCandidateGlossaryCategoryGUIDs(List<String> candidateGlossaryCategoryGUIDs) {
        this.candidateGlossaryCategoryGUIDs = candidateGlossaryCategoryGUIDs;
    }

    @Override
    public String toString() {
        return "SemanticAnnotation{informalTerm='" + this.informalTerm + '\'' + ", informalTopic='" + this.informalTopic + '\'' + ", candidateGlossaryTermGUIDs=" + this.candidateGlossaryTermGUIDs + ", candidateGlossaryCategoryGUIDs=" + this.candidateGlossaryCategoryGUIDs + ", annotationType='" + this.annotationType + '\'' + ", summary='" + this.summary + '\'' + ", confidenceLevel=" + this.confidenceLevel + ", expression='" + this.expression + '\'' + ", explanation='" + this.explanation + '\'' + ", analysisStep='" + this.analysisStep + '\'' + ", jsonProperties='" + this.jsonProperties + '\'' + ", numAttachedAnnotations=" + this.numAttachedAnnotations + ", annotationStatus=" + this.annotationStatus + ", reviewDate=" + this.reviewDate + ", steward='" + this.steward + '\'' + ", reviewComment='" + this.reviewComment + '\'' + ", additionalProperties=" + this.additionalProperties + ", type=" + this.type + ", guid='" + this.guid + '\'' + ", url='" + this.url + '\'' + ", classifications=" + this.classifications + ", extendedProperties=" + this.extendedProperties + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SemanticAnnotation that = (SemanticAnnotation)((Object)objectToCompare);
        return Objects.equals(this.informalTerm, that.informalTerm) && Objects.equals(this.informalTopic, that.informalTopic) && Objects.equals(this.candidateGlossaryTermGUIDs, that.candidateGlossaryTermGUIDs) && Objects.equals(this.candidateGlossaryCategoryGUIDs, that.candidateGlossaryCategoryGUIDs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.informalTerm, this.informalTopic, this.candidateGlossaryTermGUIDs, this.candidateGlossaryCategoryGUIDs);
    }
}

