/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourceMeasurementAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataSourcePhysicalStatusAnnotation
extends DataSourceMeasurementAnnotation {
    private static final long serialVersionUID = 1L;
    private Date createTime = null;
    private Date modifiedTime = null;
    private int size = 0;
    private String encoding = null;

    public DataSourcePhysicalStatusAnnotation() {
    }

    public DataSourcePhysicalStatusAnnotation(DataSourcePhysicalStatusAnnotation template) {
        super(template);
        if (template != null) {
            this.createTime = template.getCreateTime();
            this.modifiedTime = template.getModifiedTime();
            this.size = template.getSize();
            this.encoding = template.getEncoding();
        }
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(Date modifiedTime) {
        this.modifiedTime = modifiedTime;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public String toString() {
        return "DataSourcePhysicalStatusAnnotation{createTime=" + this.createTime + ", modifiedTime=" + this.modifiedTime + ", size=" + this.size + ", encoding='" + this.encoding + '\'' + ", dataSourceProperties=" + this.getDataSourceProperties() + ", annotationType='" + this.getAnnotationType() + '\'' + ", summary='" + this.getSummary() + '\'' + ", confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + '\'' + ", explanation='" + this.getExplanation() + '\'' + ", analysisStep='" + this.getAnalysisStep() + '\'' + ", jsonProperties='" + this.getJsonProperties() + '\'' + ", annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + '\'' + ", reviewComment='" + this.getReviewComment() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataSourcePhysicalStatusAnnotation that = (DataSourcePhysicalStatusAnnotation)objectToCompare;
        return this.getSize() == that.getSize() && Objects.equals(this.getCreateTime(), that.getCreateTime()) && Objects.equals(this.getModifiedTime(), that.getModifiedTime()) && Objects.equals(this.getEncoding(), that.getEncoding());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getCreateTime(), this.getModifiedTime(), this.getSize(), this.getEncoding());
    }
}

