/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SuspectDuplicateAnnotation
extends Annotation {
    private static final long serialVersionUID = 1L;
    private List<String> duplicateAnchorGUIDs = null;
    private List<String> matchingPropertyNames = null;
    private List<String> matchingClassificationNames = null;
    private List<String> matchingAttachmentGUIDs = null;
    private List<String> matchingRelationshipGUIDs = null;

    public SuspectDuplicateAnnotation() {
    }

    public SuspectDuplicateAnnotation(SuspectDuplicateAnnotation template) {
        super(template);
        if (template != null) {
            this.duplicateAnchorGUIDs = template.getDuplicateAnchorGUIDs();
            this.matchingPropertyNames = template.getMatchingPropertyNames();
            this.matchingClassificationNames = template.getMatchingClassificationNames();
            this.matchingAttachmentGUIDs = template.getMatchingAttachmentGUIDs();
            this.matchingRelationshipGUIDs = template.getMatchingRelationshipGUIDs();
        }
    }

    public List<String> getDuplicateAnchorGUIDs() {
        if (this.duplicateAnchorGUIDs == null) {
            return null;
        }
        if (this.duplicateAnchorGUIDs.isEmpty()) {
            return null;
        }
        return this.duplicateAnchorGUIDs;
    }

    public void setDuplicateAnchorGUIDs(List<String> duplicateAnchorGUIDs) {
        this.duplicateAnchorGUIDs = duplicateAnchorGUIDs;
    }

    public List<String> getMatchingPropertyNames() {
        if (this.matchingPropertyNames == null) {
            return null;
        }
        if (this.matchingPropertyNames.isEmpty()) {
            return null;
        }
        return this.matchingPropertyNames;
    }

    public void setMatchingPropertyNames(List<String> matchingPropertyNames) {
        this.matchingPropertyNames = matchingPropertyNames;
    }

    public List<String> getMatchingClassificationNames() {
        if (this.matchingClassificationNames == null) {
            return null;
        }
        if (this.matchingClassificationNames.isEmpty()) {
            return null;
        }
        return this.matchingClassificationNames;
    }

    public void setMatchingClassificationNames(List<String> matchingClassificationNames) {
        this.matchingClassificationNames = matchingClassificationNames;
    }

    public List<String> getMatchingAttachmentGUIDs() {
        if (this.matchingAttachmentGUIDs == null) {
            return null;
        }
        if (this.matchingAttachmentGUIDs.isEmpty()) {
            return null;
        }
        return this.matchingAttachmentGUIDs;
    }

    public void setMatchingAttachmentGUIDs(List<String> matchingAttachmentGUIDs) {
        this.matchingAttachmentGUIDs = matchingAttachmentGUIDs;
    }

    public List<String> getMatchingRelationshipGUIDs() {
        if (this.matchingRelationshipGUIDs == null) {
            return null;
        }
        if (this.matchingRelationshipGUIDs.isEmpty()) {
            return null;
        }
        return this.matchingRelationshipGUIDs;
    }

    public void setMatchingRelationshipGUIDs(List<String> matchingRelationshipGUIDs) {
        this.matchingRelationshipGUIDs = matchingRelationshipGUIDs;
    }

    @Override
    public String toString() {
        return "SuspectDuplicateAnnotation{duplicateAnchorGUIDs=" + this.duplicateAnchorGUIDs + ", matchingPropertyNames=" + this.matchingPropertyNames + ", matchingClassificationNames=" + this.matchingClassificationNames + ", matchingAttachmentGUIDs=" + this.matchingAttachmentGUIDs + ", matchingRelationshipGUIDs=" + this.matchingRelationshipGUIDs + ", annotationType='" + this.getAnnotationType() + '\'' + ", summary='" + this.getSummary() + '\'' + ", confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + '\'' + ", explanation='" + this.getExplanation() + '\'' + ", analysisStep='" + this.getAnalysisStep() + '\'' + ", jsonProperties='" + this.getJsonProperties() + '\'' + ", annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + '\'' + ", reviewComment='" + this.getReviewComment() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        SuspectDuplicateAnnotation that = (SuspectDuplicateAnnotation)objectToCompare;
        return Objects.equals(this.duplicateAnchorGUIDs, that.duplicateAnchorGUIDs) && Objects.equals(this.matchingPropertyNames, that.matchingPropertyNames) && Objects.equals(this.matchingClassificationNames, that.matchingClassificationNames) && Objects.equals(this.matchingAttachmentGUIDs, that.matchingAttachmentGUIDs) && Objects.equals(this.matchingRelationshipGUIDs, that.matchingRelationshipGUIDs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.duplicateAnchorGUIDs, this.matchingPropertyNames, this.matchingClassificationNames, this.matchingAttachmentGUIDs, this.matchingRelationshipGUIDs);
    }
}

