/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DivergentAttachmentAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DivergentAttachmentClassificationAnnotation
extends DivergentAttachmentAnnotation {
    private static final long serialVersionUID = 1L;
    private String divergentClassificationName = null;
    private List<String> divergentClassificationPropertyNames = null;

    public DivergentAttachmentClassificationAnnotation() {
    }

    public DivergentAttachmentClassificationAnnotation(DivergentAttachmentClassificationAnnotation template) {
        super(template);
        if (template != null) {
            this.divergentClassificationName = template.getDivergentClassificationName();
            this.divergentClassificationPropertyNames = template.getDivergentClassificationPropertyNames();
        }
    }

    public String getDivergentClassificationName() {
        return this.divergentClassificationName;
    }

    public void setDivergentClassificationName(String divergentClassificationName) {
        this.divergentClassificationName = divergentClassificationName;
    }

    public List<String> getDivergentClassificationPropertyNames() {
        if (this.divergentClassificationPropertyNames == null) {
            return null;
        }
        if (this.divergentClassificationPropertyNames.isEmpty()) {
            return null;
        }
        return this.divergentClassificationPropertyNames;
    }

    public void setDivergentClassificationPropertyNames(List<String> divergentClassificationPropertyNames) {
        this.divergentClassificationPropertyNames = divergentClassificationPropertyNames;
    }

    @Override
    public String toString() {
        return "DivergentAttachmentClassificationAnnotation{divergentClassificationName='" + this.divergentClassificationName + '\'' + ", divergentClassificationPropertyNames=" + this.divergentClassificationPropertyNames + ", attachmentGUID='" + this.getAttachmentGUID() + '\'' + ", duplicateAttachmentGUID='" + this.getDuplicateAttachmentGUID() + '\'' + ", duplicateAnchorGUIDs='" + this.getDuplicateAnchorGUID() + '\'' + ", annotationType='" + this.getAnnotationType() + '\'' + ", summary='" + this.getSummary() + '\'' + ", confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + '\'' + ", explanation='" + this.getExplanation() + '\'' + ", analysisStep='" + this.getAnalysisStep() + '\'' + ", jsonProperties='" + this.getJsonProperties() + '\'' + ", annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + '\'' + ", reviewComment='" + this.getReviewComment() + '\'' + ", additionalProperties=" + this.getAdditionalProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + '\'' + ", extendedProperties=" + this.getExtendedProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DivergentAttachmentClassificationAnnotation that = (DivergentAttachmentClassificationAnnotation)objectToCompare;
        return Objects.equals(this.divergentClassificationName, that.divergentClassificationName) && Objects.equals(this.divergentClassificationPropertyNames, that.divergentClassificationPropertyNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.divergentClassificationName, this.divergentClassificationPropertyNames);
    }
}

