/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.PropertyBase;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DiscoveryEngineProperties
extends PropertyBase {
    private static final long serialVersionUID = 1L;
    private String qualifiedName = null;
    private String displayName = null;
    private String description = null;
    private String typeDescription = null;
    private String version = null;
    private String patchLevel = null;
    private String source = null;
    private Map<String, String> additionalProperties = null;

    public DiscoveryEngineProperties() {
    }

    public DiscoveryEngineProperties(DiscoveryEngineProperties template) {
        super(template);
        if (template != null) {
            this.qualifiedName = template.getQualifiedName();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.typeDescription = template.getTypeDescription();
            this.version = template.getVersion();
            this.patchLevel = template.getPatchLevel();
            this.source = template.getSource();
            this.additionalProperties = template.getAdditionalProperties();
        }
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPatchLevel() {
        return this.patchLevel;
    }

    public void setPatchLevel(String patchLevel) {
        this.patchLevel = patchLevel;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Map<String, String> getAdditionalProperties() {
        if (this.additionalProperties == null) {
            return null;
        }
        if (this.additionalProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.additionalProperties);
    }

    public String toString() {
        return "DiscoveryEngineProperties{qualifiedName='" + this.qualifiedName + "', displayName='" + this.displayName + "', description='" + this.description + "', typeDescription='" + this.typeDescription + "', version='" + this.version + "', patchLevel='" + this.patchLevel + "', source='" + this.source + "', additionalProperties=" + this.additionalProperties + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DiscoveryEngineProperties that = (DiscoveryEngineProperties)objectToCompare;
        return Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getTypeDescription(), that.getTypeDescription()) && Objects.equals(this.getVersion(), that.getVersion()) && Objects.equals(this.getPatchLevel(), that.getPatchLevel()) && Objects.equals(this.getSource(), that.getSource());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDisplayName(), this.getDescription(), this.getTypeDescription(), this.getVersion(), this.getPatchLevel(), this.getSource());
    }
}

