/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.discovery.DiscoveryContext;
import org.odpi.openmetadata.frameworks.discovery.OpenDiscoveryService;
import org.odpi.openmetadata.frameworks.discovery.ffdc.DiscoveryServiceException;
import org.odpi.openmetadata.frameworks.discovery.ffdc.ODFErrorCode;

public abstract class DiscoveryService
extends ConnectorBase
implements OpenDiscoveryService,
AuditLoggingComponent,
VirtualConnectorExtension {
    protected String discoveryServiceName = "<Unknown>";
    protected DiscoveryContext discoveryContext = null;
    protected AuditLog auditLog = null;
    protected List<Connector> embeddedConnectors = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    public synchronized void setDiscoveryContext(DiscoveryContext discoveryContext) {
        this.discoveryContext = discoveryContext;
    }

    public void setDiscoveryServiceName(String discoveryServiceName) {
        this.discoveryServiceName = discoveryServiceName;
    }

    public synchronized DiscoveryContext getDiscoveryContext() {
        return this.discoveryContext;
    }

    protected List<DiscoveryService> getEmbeddedDiscoveryServices() throws DiscoveryServiceException {
        String methodName = "getEmbeddedDiscoveryServices";
        ArrayList<DiscoveryService> discoveryServices = null;
        if (this.embeddedConnectors != null) {
            discoveryServices = new ArrayList<DiscoveryService>();
            for (Connector embeddedConnector : this.embeddedConnectors) {
                if (embeddedConnector == null) continue;
                if (embeddedConnector instanceof DiscoveryService) {
                    discoveryServices.add((DiscoveryService)embeddedConnector);
                    continue;
                }
                throw new DiscoveryServiceException(ODFErrorCode.INVALID_EMBEDDED_DISCOVERY_SERVICE.getMessageDefinition(this.discoveryServiceName), this.getClass().getName(), "getEmbeddedDiscoveryServices");
            }
            if (discoveryServices.isEmpty()) {
                discoveryServices = null;
            }
        }
        return discoveryServices;
    }

    public void start() throws ConnectorCheckedException {
        super.start();
        String methodName = "start";
        if (this.discoveryContext == null) {
            throw new DiscoveryServiceException(ODFErrorCode.NULL_DISCOVERY_CONTEXT.getMessageDefinition(this.discoveryServiceName), this.getClass().getName(), "start");
        }
    }

    protected void handleUnexpectedException(String methodName, Throwable error) throws ConnectorCheckedException {
        throw new DiscoveryServiceException(ODFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.discoveryServiceName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName);
    }

    public void disconnect() throws ConnectorCheckedException {
        super.disconnect();
    }
}

