/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataProfileAnnotation
extends DataFieldAnnotation {
    private static final long serialVersionUID = 1L;
    private int length = 0;
    private String inferredDataType = null;
    private String inferredFormat = null;
    private int inferredLength = 0;
    private int inferredPrecision = 0;
    private int inferredScale = 0;
    private Map<String, String> profileProperties = null;
    private Map<String, Boolean> profileFlags = null;
    private Map<String, Long> profileCounts = null;
    private List<String> valueList = null;
    private Map<String, Integer> valueCount = null;
    private String valueRangeFrom = null;
    private String valueRangeTo = null;
    private String averageValue = null;

    public DataProfileAnnotation() {
    }

    public DataProfileAnnotation(DataProfileAnnotation template) {
        super(template);
        if (template != null) {
            this.length = template.getLength();
            this.inferredDataType = template.getInferredDataType();
            this.inferredFormat = template.getInferredFormat();
            this.inferredLength = template.getInferredLength();
            this.inferredPrecision = template.getInferredPrecision();
            this.inferredScale = template.getInferredScale();
            this.profileProperties = template.getProfileProperties();
            this.profileFlags = template.getProfileFlags();
            this.profileCounts = template.getProfileCounts();
            this.valueList = template.getValueList();
            this.valueCount = template.getValueCount();
            this.valueRangeFrom = template.getValueRangeFrom();
            this.valueRangeTo = template.getValueRangeTo();
            this.averageValue = template.getAverageValue();
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getInferredDataType() {
        return this.inferredDataType;
    }

    public void setInferredDataType(String inferredDataType) {
        this.inferredDataType = inferredDataType;
    }

    public String getInferredFormat() {
        return this.inferredFormat;
    }

    public void setInferredFormat(String inferredFormat) {
        this.inferredFormat = inferredFormat;
    }

    public int getInferredLength() {
        return this.inferredLength;
    }

    public void setInferredLength(int inferredLength) {
        this.inferredLength = inferredLength;
    }

    public int getInferredPrecision() {
        return this.inferredPrecision;
    }

    public void setInferredPrecision(int inferredPrecision) {
        this.inferredPrecision = inferredPrecision;
    }

    public int getInferredScale() {
        return this.inferredScale;
    }

    public void setInferredScale(int inferredScale) {
        this.inferredScale = inferredScale;
    }

    public Map<String, String> getProfileProperties() {
        if (this.profileProperties == null) {
            return null;
        }
        if (this.profileProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.profileProperties);
    }

    public void setProfileProperties(Map<String, String> profileProperties) {
        this.profileProperties = profileProperties;
    }

    public Map<String, Boolean> getProfileFlags() {
        if (this.profileFlags == null) {
            return null;
        }
        if (this.profileFlags.isEmpty()) {
            return null;
        }
        return new HashMap<String, Boolean>(this.profileFlags);
    }

    public void setProfileFlags(Map<String, Boolean> profileFlags) {
        this.profileFlags = profileFlags;
    }

    public Map<String, Long> getProfileCounts() {
        if (this.profileCounts == null) {
            return null;
        }
        if (this.profileCounts.isEmpty()) {
            return null;
        }
        return new HashMap<String, Long>(this.profileCounts);
    }

    public void setProfileCounts(Map<String, Long> profileCounts) {
        this.profileCounts = profileCounts;
    }

    public List<String> getValueList() {
        if (this.valueList == null) {
            return null;
        }
        if (this.valueList.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.valueList);
    }

    public void setValueList(List<String> valueList) {
        this.valueList = valueList;
    }

    public Map<String, Integer> getValueCount() {
        if (this.valueCount == null) {
            return null;
        }
        if (this.valueCount.isEmpty()) {
            return null;
        }
        return new HashMap<String, Integer>(this.valueCount);
    }

    public void setValueCount(Map<String, Integer> valueCount) {
        this.valueCount = valueCount;
    }

    public String getValueRangeFrom() {
        return this.valueRangeFrom;
    }

    public void setValueRangeFrom(String valueRangeFrom) {
        this.valueRangeFrom = valueRangeFrom;
    }

    public String getValueRangeTo() {
        return this.valueRangeTo;
    }

    public void setValueRangeTo(String valueRangeTo) {
        this.valueRangeTo = valueRangeTo;
    }

    public String getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(String averageValue) {
        this.averageValue = averageValue;
    }

    @Override
    public String toString() {
        return "DataProfileAnnotation{length=" + this.length + ", inferredDataType='" + this.inferredDataType + "', inferredFormat='" + this.inferredFormat + "', inferredLength=" + this.inferredLength + ", inferredPrecision=" + this.inferredPrecision + ", inferredScale=" + this.inferredScale + ", profileProperties=" + this.profileProperties + ", profileFlags=" + this.profileFlags + ", profileCounts=" + this.profileCounts + ", valueList=" + this.valueList + ", valueCount=" + this.valueCount + ", valueRangeFrom='" + this.valueRangeFrom + "', valueRangeTo='" + this.valueRangeTo + "', averageValue='" + this.averageValue + "', annotationType='" + this.getAnnotationType() + "', summary='" + this.getSummary() + "', confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + "', explanation='" + this.getExplanation() + "', analysisStep='" + this.getAnalysisStep() + "', jsonProperties='" + this.getJsonProperties() + "', annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + "', reviewComment='" + this.getReviewComment() + "', additionalProperties=" + this.getAdditionalProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataProfileAnnotation that = (DataProfileAnnotation)objectToCompare;
        return this.length == that.length && this.inferredLength == that.inferredLength && this.inferredPrecision == that.inferredPrecision && this.inferredScale == that.inferredScale && Objects.equals(this.inferredDataType, that.inferredDataType) && Objects.equals(this.inferredFormat, that.inferredFormat) && Objects.equals(this.profileProperties, that.profileProperties) && Objects.equals(this.profileFlags, that.profileFlags) && Objects.equals(this.profileCounts, that.profileCounts) && Objects.equals(this.valueList, that.valueList) && Objects.equals(this.valueCount, that.valueCount) && Objects.equals(this.valueRangeFrom, that.valueRangeFrom) && Objects.equals(this.valueRangeTo, that.valueRangeTo) && Objects.equals(this.averageValue, that.averageValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length, this.inferredDataType, this.inferredFormat, this.inferredLength, this.inferredPrecision, this.inferredScale, this.profileProperties, this.profileFlags, this.profileCounts, this.valueList, this.valueCount, this.valueRangeFrom, this.valueRangeTo, this.averageValue);
    }
}

