/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.DataFieldAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class DataProfileLogAnnotation
extends DataFieldAnnotation {
    private static final long serialVersionUID = 1L;
    private List<String> dataProfileLogFileNames = null;

    public DataProfileLogAnnotation() {
    }

    public DataProfileLogAnnotation(DataProfileLogAnnotation template) {
        super(template);
        if (template != null) {
            this.dataProfileLogFileNames = template.getDataProfileLogFileNames();
        }
    }

    public List<String> getDataProfileLogFileNames() {
        if (this.dataProfileLogFileNames == null) {
            return null;
        }
        if (this.dataProfileLogFileNames.isEmpty()) {
            return null;
        }
        return this.dataProfileLogFileNames;
    }

    public void setDataProfileLogFileNames(List<String> dataProfileLogFileNames) {
        this.dataProfileLogFileNames = dataProfileLogFileNames;
    }

    @Override
    public String toString() {
        return "DataProfileLogAnnotation{dataProfileLogFileNames=" + this.dataProfileLogFileNames + ", annotationType='" + this.getAnnotationType() + "', summary='" + this.getSummary() + "', confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + "', explanation='" + this.getExplanation() + "', analysisStep='" + this.getAnalysisStep() + "', jsonProperties='" + this.getJsonProperties() + "', annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + "', reviewComment='" + this.getReviewComment() + "', additionalProperties=" + this.getAdditionalProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataProfileLogAnnotation that = (DataProfileLogAnnotation)objectToCompare;
        return Objects.equals(this.dataProfileLogFileNames, that.dataProfileLogFileNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataProfileLogFileNames);
    }
}

