/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum AnnotationStatus implements Serializable
{
    NEW_ANNOTATION(0, 0, "New", "Annotation has been created but not reviewed"),
    REVIEWED_ANNOTATION(1, 1, "Reviewed", "Annotation has been reviewed by no decision has been made"),
    APPROVED_ANNOTATION(2, 2, "Approved", "Annotation has been approved"),
    ACTIONED_ANNOTATION(3, 3, "Actioned", "Annotation has been approved and insight has been added to Asset's metadata"),
    INVALID_ANNOTATION(4, 4, "Invalid", "Annotation has been reviewed and declared invalid"),
    IGNORE_ANNOTATION(5, 5, "Ignore", "Annotation is invalid and should be ignored"),
    OTHER_STATUS(98, 99, "Other", "Annotation's status stored in additional properties"),
    UNKNOWN_STATUS(99, 0, "Unknown", "Annotation has not had a status assigned");

    private static final long serialVersionUID = 1L;
    public static final String ENUM_TYPE_GUID = "71187df6-ef66-4f88-bc03-cd3c7f925165";
    public static final String ENUM_TYPE_NAME = "AnnotationStatus";
    private int statusCode;
    private int openTypeOrdinal;
    private String statusName;
    private String statusDescription;

    private AnnotationStatus(int statusCode, int openTypeOrdinal, String statusName, String statusDescription) {
        this.statusCode = statusCode;
        this.openTypeOrdinal = openTypeOrdinal;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getOrdinal() {
        return this.statusCode;
    }

    public String getName() {
        return this.statusName;
    }

    public String getDescription() {
        return this.statusDescription;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "AnnotationStatus{statusCode=" + this.statusCode + ", openTypeOrdinal=" + this.openTypeOrdinal + ", statusName='" + this.statusName + "', statusDescription='" + this.statusDescription + "'}";
    }
}

