/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementClassificationHeader;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementOrigin;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.ElementType;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ElementClassificationHeader.class, name="ElementClassificationHeader"), @JsonSubTypes.Type(value=ElementType.class, name="ElementType")})
public class ElementControlHeader
implements Serializable {
    public static final long CURRENT_AUDIT_HEADER_VERSION = 1L;
    private static final long serialVersionUID = 1L;
    private long headerVersion = 0L;
    private String elementSourceServer = null;
    private ElementOrigin elementOrigin = ElementOrigin.CONFIGURATION;
    private String elementMetadataCollectionId = null;
    private String elementMetadataCollectionName = null;
    private String elementLicense = null;
    private String elementCreatedBy = null;
    private String elementUpdatedBy = null;
    private List<String> elementMaintainedBy = null;
    private Date elementCreateTime = null;
    private Date elementUpdateTime = null;
    private long elementVersion = 0L;
    private ElementStatus elementStatus = null;
    private Map<String, Serializable> mappingProperties = null;

    public ElementControlHeader() {
    }

    public ElementControlHeader(ElementControlHeader template) {
        if (template != null) {
            this.headerVersion = template.getHeaderVersion();
            this.elementSourceServer = template.getElementSourceServer();
            this.elementOrigin = template.getElementOrigin();
            this.elementMetadataCollectionId = template.getElementMetadataCollectionId();
            this.elementMetadataCollectionName = template.getElementMetadataCollectionName();
            this.elementLicense = template.getElementLicense();
            this.elementCreatedBy = template.getElementCreatedBy();
            this.elementUpdatedBy = template.getElementUpdatedBy();
            this.elementMaintainedBy = template.getElementMaintainedBy();
            this.elementCreateTime = template.getElementCreateTime();
            this.elementUpdateTime = template.getElementUpdateTime();
            this.elementVersion = template.getElementVersion();
            this.elementStatus = template.getStatus();
            this.mappingProperties = template.getMappingProperties();
        }
    }

    public long getHeaderVersion() {
        return this.headerVersion;
    }

    public void setHeaderVersion(long headerVersion) {
        this.headerVersion = headerVersion;
    }

    public void setElementSourceServer(String elementSourceServer) {
        this.elementSourceServer = elementSourceServer;
    }

    public String getElementSourceServer() {
        return this.elementSourceServer;
    }

    public void setElementOrigin(ElementOrigin elementOrigin) {
        this.elementOrigin = elementOrigin;
    }

    public ElementOrigin getElementOrigin() {
        return this.elementOrigin;
    }

    public String getElementMetadataCollectionId() {
        return this.elementMetadataCollectionId;
    }

    public void setElementMetadataCollectionId(String elementMetadataCollectionId) {
        this.elementMetadataCollectionId = elementMetadataCollectionId;
    }

    public String getElementMetadataCollectionName() {
        return this.elementMetadataCollectionName;
    }

    public void setElementMetadataCollectionName(String elementMetadataCollectionName) {
        this.elementMetadataCollectionName = elementMetadataCollectionName;
    }

    public String getElementLicense() {
        return this.elementLicense;
    }

    public void setElementLicense(String elementLicense) {
        this.elementLicense = elementLicense;
    }

    public ElementStatus getStatus() {
        return this.elementStatus;
    }

    public void setStatus(ElementStatus newStatus) {
        this.elementStatus = newStatus;
    }

    public String getElementCreatedBy() {
        return this.elementCreatedBy;
    }

    public void setElementCreatedBy(String elementCreatedBy) {
        this.elementCreatedBy = elementCreatedBy;
    }

    public String getElementUpdatedBy() {
        return this.elementUpdatedBy;
    }

    public void setElementUpdatedBy(String elementUpdatedBy) {
        this.elementUpdatedBy = elementUpdatedBy;
    }

    public List<String> getElementMaintainedBy() {
        if (this.elementMaintainedBy == null) {
            return null;
        }
        if (this.elementMaintainedBy.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(this.elementMaintainedBy);
    }

    public void setElementMaintainedBy(List<String> elementMaintainedBy) {
        this.elementMaintainedBy = elementMaintainedBy;
    }

    public Date getElementCreateTime() {
        if (this.elementCreateTime == null) {
            return null;
        }
        return new Date(this.elementCreateTime.getTime());
    }

    public void setElementCreateTime(Date elementCreateTime) {
        this.elementCreateTime = elementCreateTime;
    }

    public Date getElementUpdateTime() {
        if (this.elementUpdateTime == null) {
            return null;
        }
        return new Date(this.elementUpdateTime.getTime());
    }

    public void setElementUpdateTime(Date elementUpdateTime) {
        this.elementUpdateTime = elementUpdateTime;
    }

    public long getElementVersion() {
        return this.elementVersion;
    }

    public void setElementVersion(long elementVersion) {
        this.elementVersion = elementVersion;
    }

    public Map<String, Serializable> getMappingProperties() {
        if (this.mappingProperties == null) {
            return null;
        }
        if (this.mappingProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, Serializable>(this.mappingProperties);
    }

    public void setMappingProperties(Map<String, Serializable> mappingProperties) {
        this.mappingProperties = mappingProperties;
    }

    public String toString() {
        return "ElementControlHeader{elementSourceServer='" + this.elementSourceServer + "', elementOrigin=" + this.elementOrigin + ", elementMetadataCollectionId='" + this.elementMetadataCollectionId + "', elementMetadataCollectionName='" + this.elementMetadataCollectionName + "', elementLicense='" + this.elementLicense + "', elementCreatedBy='" + this.elementCreatedBy + "', elementUpdatedBy='" + this.elementUpdatedBy + "', elementMaintainedBy=" + this.elementMaintainedBy + ", elementCreateTime=" + this.elementCreateTime + ", elementUpdateTime=" + this.elementUpdateTime + ", elementVersion=" + this.elementVersion + ", elementStatus=" + this.elementStatus + ", mappingProperties=" + this.mappingProperties + ", status=" + this.getStatus() + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ElementControlHeader that = (ElementControlHeader)objectToCompare;
        return this.elementVersion == that.elementVersion && Objects.equals(this.elementSourceServer, that.elementSourceServer) && this.elementOrigin == that.elementOrigin && Objects.equals(this.elementMetadataCollectionId, that.elementMetadataCollectionId) && Objects.equals(this.elementMetadataCollectionName, that.elementMetadataCollectionName) && Objects.equals(this.elementLicense, that.elementLicense) && Objects.equals(this.elementCreatedBy, that.elementCreatedBy) && Objects.equals(this.elementUpdatedBy, that.elementUpdatedBy) && Objects.equals(this.elementMaintainedBy, that.elementMaintainedBy) && Objects.equals(this.elementCreateTime, that.elementCreateTime) && Objects.equals(this.elementUpdateTime, that.elementUpdateTime) && this.elementStatus == that.elementStatus && Objects.equals(this.mappingProperties, that.mappingProperties);
    }

    public int hashCode() {
        return Objects.hash(this.elementSourceServer, this.elementOrigin, this.elementMetadataCollectionId, this.elementMetadataCollectionName, this.elementLicense, this.elementCreatedBy, this.elementUpdatedBy, this.elementMaintainedBy, this.elementCreateTime, this.elementUpdateTime, this.elementVersion, this.elementStatus, this.mappingProperties);
    }
}

