/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.Annotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourcePhysicalStatusAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataSourcePhysicalStatusAnnotation.class, name="DataSourcePhysicalStatusAnnotation")})
public class DataSourceMeasurementAnnotation
extends Annotation {
    private static final long serialVersionUID = 1L;
    private Map<String, String> dataSourceProperties = null;

    public DataSourceMeasurementAnnotation() {
    }

    public DataSourceMeasurementAnnotation(DataSourceMeasurementAnnotation template) {
        super(template);
        if (template != null) {
            this.dataSourceProperties = template.getDataSourceProperties();
        }
    }

    public Map<String, String> getDataSourceProperties() {
        if (this.dataSourceProperties == null) {
            return null;
        }
        if (this.dataSourceProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, String>(this.dataSourceProperties);
    }

    public void setDataSourceProperties(Map<String, String> dataSourceProperties) {
        this.dataSourceProperties = dataSourceProperties;
    }

    @Override
    public String toString() {
        return "DataSourceMeasurementAnnotation{dataSourceProperties=" + this.dataSourceProperties + ", annotationType='" + this.getAnnotationType() + "', summary='" + this.getSummary() + "', confidenceLevel=" + this.getConfidenceLevel() + ", expression='" + this.getExpression() + "', explanation='" + this.getExplanation() + "', analysisStep='" + this.getAnalysisStep() + "', jsonProperties='" + this.getJsonProperties() + "', annotationStatus=" + this.getAnnotationStatus() + ", numAttachedAnnotations=" + this.getNumAttachedAnnotations() + ", reviewDate=" + this.getReviewDate() + ", steward='" + this.getSteward() + "', reviewComment='" + this.getReviewComment() + "', additionalProperties=" + this.getAdditionalProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        DataSourceMeasurementAnnotation that = (DataSourceMeasurementAnnotation)objectToCompare;
        return Objects.equals(this.getDataSourceProperties(), that.getDataSourceProperties());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getDataSourceProperties());
    }
}

