/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.discovery.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.discovery.properties.AnnotationStatus;
import org.odpi.openmetadata.frameworks.discovery.properties.DataFieldAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.DataSourceMeasurementAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.PropertyBase;
import org.odpi.openmetadata.frameworks.discovery.properties.SchemaAnalysisAnnotation;
import org.odpi.openmetadata.frameworks.discovery.properties.SuspectDuplicateAnnotation;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SchemaAnalysisAnnotation.class, name="SchemaAnalysisAnnotation"), @JsonSubTypes.Type(value=DataSourceMeasurementAnnotation.class, name="DataSourceMeasurementAnnotation"), @JsonSubTypes.Type(value=DataFieldAnnotation.class, name="DataFieldAnnotation"), @JsonSubTypes.Type(value=SuspectDuplicateAnnotation.class, name="SuspectDuplicateAnnotation")})
public class Annotation
extends PropertyBase {
    private static final long serialVersionUID = 1L;
    private String annotationType = null;
    private String summary = null;
    private int confidenceLevel = 0;
    private String expression = null;
    private String explanation = null;
    private String analysisStep = null;
    private String jsonProperties = null;
    private int numAttachedAnnotations = 0;
    private AnnotationStatus annotationStatus = null;
    private Date reviewDate = null;
    private String steward = null;
    private String reviewComment = null;
    private Map<String, String> additionalProperties = null;

    public Annotation() {
    }

    public Annotation(Annotation template) {
        super(template);
        if (template != null) {
            this.annotationType = template.getAnnotationType();
            this.summary = template.getSummary();
            this.confidenceLevel = template.getConfidenceLevel();
            this.expression = template.getExpression();
            this.explanation = template.getExplanation();
            this.analysisStep = template.getAnalysisStep();
            this.jsonProperties = template.getJsonProperties();
            this.numAttachedAnnotations = template.getNumAttachedAnnotations();
            this.annotationStatus = template.getAnnotationStatus();
            this.reviewDate = template.getReviewDate();
            this.steward = template.getSteward();
            this.reviewComment = template.getReviewComment();
            this.additionalProperties = template.getAdditionalProperties();
        }
    }

    public String getAnnotationType() {
        return this.annotationType;
    }

    public void setAnnotationType(String annotationType) {
        this.annotationType = annotationType;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public int getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public void setConfidenceLevel(int confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public String getAnalysisStep() {
        return this.analysisStep;
    }

    public void setAnalysisStep(String analysisStep) {
        this.analysisStep = analysisStep;
    }

    public String getJsonProperties() {
        return this.jsonProperties;
    }

    public void setJsonProperties(String jsonProperties) {
        this.jsonProperties = jsonProperties;
    }

    public AnnotationStatus getAnnotationStatus() {
        return this.annotationStatus;
    }

    public void setAnnotationStatus(AnnotationStatus annotationStatus) {
        this.annotationStatus = annotationStatus;
    }

    public int getNumAttachedAnnotations() {
        return this.numAttachedAnnotations;
    }

    public void setNumAttachedAnnotations(int number) {
        this.numAttachedAnnotations = number;
    }

    public Date getReviewDate() {
        return this.reviewDate;
    }

    public void setReviewDate(Date reviewDate) {
        this.reviewDate = reviewDate;
    }

    public String getSteward() {
        return this.steward;
    }

    public void setSteward(String steward) {
        this.steward = steward;
    }

    public String getReviewComment() {
        return this.reviewComment;
    }

    public void setReviewComment(String reviewComment) {
        this.reviewComment = reviewComment;
    }

    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, String> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public String toString() {
        return "Annotation{annotationType='" + this.annotationType + "', summary='" + this.summary + "', confidenceLevel=" + this.confidenceLevel + ", expression='" + this.expression + "', explanation='" + this.explanation + "', analysisStep='" + this.analysisStep + "', jsonProperties='" + this.jsonProperties + "', numAttachedAnnotations=" + this.numAttachedAnnotations + ", annotationStatus=" + this.annotationStatus + ", reviewDate=" + this.reviewDate + ", steward='" + this.steward + "', reviewComment='" + this.reviewComment + "', additionalProperties=" + this.additionalProperties + ", headerVersion=" + this.getHeaderVersion() + ", elementHeader=" + this.getElementHeader() + ", typeName='" + this.getTypeName() + "', extendedProperties=" + this.getExtendedProperties() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        Annotation that = (Annotation)objectToCompare;
        return this.confidenceLevel == that.confidenceLevel && this.numAttachedAnnotations == that.numAttachedAnnotations && Objects.equals(this.annotationType, that.annotationType) && Objects.equals(this.summary, that.summary) && Objects.equals(this.expression, that.expression) && Objects.equals(this.explanation, that.explanation) && Objects.equals(this.analysisStep, that.analysisStep) && Objects.equals(this.jsonProperties, that.jsonProperties) && this.annotationStatus == that.annotationStatus && Objects.equals(this.reviewDate, that.reviewDate) && Objects.equals(this.steward, that.steward) && Objects.equals(this.reviewComment, that.reviewComment) && Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.annotationType, this.summary, this.confidenceLevel, this.expression, this.explanation, this.analysisStep, this.jsonProperties, this.numAttachedAnnotations, this.annotationStatus, this.reviewDate, this.steward, this.reviewComment, this.additionalProperties);
    }
}

