/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.contextmanager;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum PermittedSynchronization implements Serializable
{
    BOTH_DIRECTIONS(0, 0, "Both Directions", "Metadata exchange is permitted in both directions.  Synchronization is halted on a specific element if potentially clashing updates have occurred both in the third party technology and open metadata.  Such conflicts are logged on the audit log and resolved through manual stewardship."),
    TO_THIRD_PARTY(1, 1, "To Third Party", "The third party technology is logically downstream of open metadata.  This means the open metadata ecosystem is the originator and owner of the metadata being synchronized. Any updates detected in the third technology are overridden by the latest open metadata values."),
    FROM_THIRD_PARTY(2, 2, "From Third Party", "The third party technology is logically upstream (the originator and owner of the metadata).  Any updates made in open metadata are not passed to the third party technology and the third party technology is requested to refresh the open metadata version."),
    OTHER(99, 99, "Other", "Another type of synchronization rule - see description property.");

    private final int ordinal;
    private final int openTypeOrdinal;
    private final String name;
    private final String description;
    private static final long serialVersionUID = 1L;
    public static final String ENUM_TYPE_GUID = "973a9f4c-93fa-43a5-a0c5-d97dbd164e78";
    public static final String ENUM_TYPE_NAME = "PermittedSynchronization";

    private PermittedSynchronization(int ordinal, int openTypeOrdinal, String name, String description) {
        this.ordinal = ordinal;
        this.openTypeOrdinal = openTypeOrdinal;
        this.name = name;
        this.description = description;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "PermittedSynchronization{ordinal=" + this.ordinal + ", openTypeOrdinal=" + this.openTypeOrdinal + ", name='" + this.name + "', description='" + this.description + "', openTypeGUID='" + this.getOpenTypeGUID() + "', openTypeName='" + this.getOpenTypeName() + "'}";
    }
}

