/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.connectors;

import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.frameworks.connectors.properties.EndpointProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetChangeListener;
import org.odpi.openmetadata.frameworks.integration.connectors.CatalogTargetIntegrator;
import org.odpi.openmetadata.frameworks.integration.connectors.IntegrationConnector;
import org.odpi.openmetadata.frameworks.integration.connectors.RequestedCatalogTargetsManager;
import org.odpi.openmetadata.frameworks.integration.context.IntegrationContext;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFErrorCode;
import org.odpi.openmetadata.frameworks.integration.properties.RequestedCatalogTarget;

public abstract class IntegrationConnectorBase
extends ConnectorBase
implements IntegrationConnector,
AuditLoggingComponent,
VirtualConnectorExtension {
    protected AuditLog auditLog = null;
    protected String connectorName = null;
    protected IntegrationContext integrationContext = null;
    protected final PropertyHelper propertyHelper = new PropertyHelper();
    protected RequestedCatalogTargetsManager catalogTargetsManager = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    @Override
    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    @Override
    public void setContext(IntegrationContext integrationContext) {
        this.integrationContext = integrationContext;
    }

    @Override
    public void start() throws ConnectorCheckedException {
        super.start();
        this.catalogTargetsManager = new RequestedCatalogTargetsManager(this.connectionProperties.getConfigurationProperties(), this.connectorName, this.auditLog);
    }

    protected String getNetworkAddress(Connector assetConnector) {
        EndpointProperties endpointProperties;
        ConnectionProperties assetConnection = assetConnector.getConnection();
        if (assetConnection != null && (endpointProperties = assetConnection.getEndpoint()) != null) {
            return endpointProperties.getAddress();
        }
        return null;
    }

    protected void registerCatalogTargetChangeListener(CatalogTargetChangeListener listener) {
        this.catalogTargetsManager.registerCatalogTargetChangeListener(listener);
    }

    protected void refreshCatalogTargets(CatalogTargetIntegrator catalogTargetIntegrator) throws ConnectorCheckedException {
        String methodName = "refreshCatalogTargets";
        List<RequestedCatalogTarget> requestedCatalogTargets = this.catalogTargetsManager.refreshKnownCatalogTargets(this.integrationContext, catalogTargetIntegrator);
        if (requestedCatalogTargets == null || requestedCatalogTargets.isEmpty()) {
            this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.NO_CATALOG_TARGETS.getMessageDefinition(this.connectorName));
        } else {
            try {
                for (RequestedCatalogTarget requestedCatalogTarget : requestedCatalogTargets) {
                    boolean savedExternalSourceIsHome = this.integrationContext.getExternalSourceIsHome();
                    String savedMetadataSourceQualifiedName = this.integrationContext.getMetadataSourceQualifiedName();
                    if (requestedCatalogTarget != null && super.isActive()) {
                        try {
                            if (requestedCatalogTarget.getMetadataSourceQualifiedName() == null) {
                                this.integrationContext.setExternalSourceIsHome(false);
                            } else {
                                this.integrationContext.setMetadataSourceQualifiedName(requestedCatalogTarget.getMetadataSourceQualifiedName());
                                this.integrationContext.setExternalSourceIsHome(true);
                            }
                            this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.REFRESHING_CATALOG_TARGET.getMessageDefinition(this.connectorName, requestedCatalogTarget.getCatalogTargetName()));
                            catalogTargetIntegrator.integrateCatalogTarget(requestedCatalogTarget);
                        }
                        catch (Exception error) {
                            this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refreshCatalogTargets:" + requestedCatalogTarget.getCatalogTargetName(), error.getMessage()));
                        }
                    }
                    this.integrationContext.setExternalSourceIsHome(savedExternalSourceIsHome);
                    this.integrationContext.setMetadataSourceQualifiedName(savedMetadataSourceQualifiedName);
                }
            }
            catch (Exception error) {
                this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.connectorName, error.getClass().getName(), "refreshCatalogTargets", error.getMessage()));
            }
            this.auditLog.logMessage("refreshCatalogTargets", OIFAuditCode.REFRESHED_CATALOG_TARGETS.getMessageDefinition(this.connectorName, Integer.toString(requestedCatalogTargets.size())));
        }
    }

    @Override
    public void engage() throws ConnectorCheckedException {
        String actionDescription = "Calling default engage() method";
        throw new ConnectorCheckedException(OIFErrorCode.ENGAGE_IMPLEMENTATION_MISSING.getMessageDefinition(this.connectorName), this.getClass().getName(), "Calling default engage() method");
    }

    @Override
    public void disconnect() throws ConnectorCheckedException {
        if (this.catalogTargetsManager != null) {
            this.catalogTargetsManager.disconnect();
        }
        super.disconnect();
    }
}

