/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.filelistener;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFAuditCode;
import org.odpi.openmetadata.frameworks.integration.ffdc.OIFErrorCode;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileDirectoryListenerInterface;
import org.odpi.openmetadata.frameworks.integration.filelistener.FileListenerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesListenerManager {
    private static final Logger log = LoggerFactory.getLogger(FilesListenerManager.class);
    private static final int POLL_INTERVAL = 500;
    private final AuditLog auditLog;
    private final String connectorName;
    private final FileAlterationMonitor monitor;

    public FilesListenerManager(AuditLog auditLog, String connectorName) {
        block2: {
            this.monitor = new FileAlterationMonitor(500L);
            String methodName = "FilesListenerManager";
            this.auditLog = auditLog;
            this.connectorName = connectorName;
            try {
                this.monitor.start();
            }
            catch (Exception error) {
                if (auditLog == null) break block2;
                auditLog.logException("FilesListenerManager", OIFAuditCode.UNEXPECTED_EXC_MONITOR_START.getMessageDefinition(error.getClass().getName(), connectorName, error.getMessage()), (Throwable)error);
            }
        }
    }

    public void registerFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
        String methodName = "registerFileListener";
        String listenerParameterName = "listener";
        String fileParameterName = "fileToMonitor";
        this.validateParameter(listener, "listener", "registerFileListener");
        this.validateParameter(fileToMonitor, "fileToMonitor", "registerFileListener");
        FileAlterationObserver observer = new FileAlterationObserver(fileToMonitor.getAbsolutePath());
        FileMonitoringListener managedListener = new FileMonitoringListener(listener);
        observer.addListener((FileAlterationListener)managedListener);
        this.monitor.addObserver(observer);
        if (this.auditLog != null) {
            this.auditLog.logMessage("registerFileListener", OIFAuditCode.FILE_MONITORING_STARTING.getMessageDefinition(this.connectorName, fileToMonitor.getAbsolutePath()));
        }
    }

    public void unregisterFileListener(FileListenerInterface listener, File fileToMonitor) throws InvalidParameterException {
    }

    public void registerDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        String methodName = "registerDirectoryListener";
        String listenerParameterName = "listener";
        String directoryParameterName = "directoryToMonitor";
        this.validateParameter(listener, "listener", "registerDirectoryListener");
        this.validateParameter(directoryToMonitor, "directoryToMonitor", "registerDirectoryListener");
        FileAlterationObserver observer = new FileAlterationObserver(directoryToMonitor.getAbsolutePath(), fileFilter);
        FolderMonitoringListener managedListener = new FolderMonitoringListener(listener, false, fileFilter);
        observer.addListener((FileAlterationListener)managedListener);
        this.monitor.addObserver(observer);
        if (this.auditLog != null) {
            this.auditLog.logMessage("registerDirectoryListener", OIFAuditCode.DIRECTORY_MONITORING_STARTING.getMessageDefinition(this.connectorName, directoryToMonitor.getAbsolutePath()));
        }
    }

    public void unregisterDirectoryListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
    }

    public void registerDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor, FileFilter fileFilter) throws InvalidParameterException {
        String methodName = "registerDirectoryTreeListener";
        String listenerParameterName = "listener";
        String directoryParameterName = "directoryToMonitor";
        this.validateParameter(listener, "listener", "registerDirectoryTreeListener");
        this.validateParameter(directoryToMonitor, "directoryToMonitor", "registerDirectoryTreeListener");
        FileAlterationObserver observer = new FileAlterationObserver(directoryToMonitor.getAbsolutePath(), fileFilter);
        FolderMonitoringListener managedListener = new FolderMonitoringListener(listener, false, fileFilter);
        observer.addListener((FileAlterationListener)managedListener);
        this.monitor.addObserver(observer);
        if (this.auditLog != null) {
            this.auditLog.logMessage("registerDirectoryTreeListener", OIFAuditCode.DIRECTORY_MONITORING_STARTING.getMessageDefinition(this.connectorName, directoryToMonitor.getAbsolutePath()));
        }
    }

    public void unregisterDirectoryTreeListener(FileDirectoryListenerInterface listener, File directoryToMonitor) throws InvalidParameterException {
    }

    public void disconnect() throws ConnectorCheckedException {
        block3: {
            String methodName = "disconnect";
            try {
                this.monitor.stop(1000L);
                if (this.auditLog != null) {
                    this.auditLog.logMessage("disconnect", OIFAuditCode.FILE_SYSTEM_MONITORING_STOPPING.getMessageDefinition(this.connectorName));
                }
            }
            catch (Exception error) {
                if (this.auditLog == null) break block3;
                this.auditLog.logException("disconnect", OIFAuditCode.UNEXPECTED_EXC_MONITOR_STOP.getMessageDefinition(error.getClass().getName(), this.connectorName, error.getMessage()), (Throwable)error);
            }
        }
    }

    public void validateParameter(Object object, String nameParameter, String methodName) throws InvalidParameterException {
        if (object == null) {
            throw new InvalidParameterException(OIFErrorCode.NULL_OBJECT.getMessageDefinition(nameParameter, methodName), this.getClass().getName(), methodName, nameParameter);
        }
    }

    static class FileMonitoringListener
    extends FileAlterationListenerAdaptor {
        private final FileListenerInterface fileListenerInterface;

        FileMonitoringListener(FileListenerInterface fileListenerInterface) {
            this.fileListenerInterface = fileListenerInterface;
        }

        public void onFileCreate(File file) {
            log.debug("File created: " + file.getName());
            this.fileListenerInterface.onFileCreate(file);
        }

        public void onFileDelete(File file) {
            log.debug("File deleted: " + file.getName());
            this.fileListenerInterface.onFileDelete(file);
        }

        public void onFileChange(File file) {
            log.debug("File changed: " + file.getName());
            this.fileListenerInterface.onFileChange(file);
        }
    }

    class FolderMonitoringListener
    extends FileAlterationListenerAdaptor {
        private final FileDirectoryListenerInterface directoryListenerInterface;
        private final boolean monitorSubDirectories;
        private final FileFilter fileFilter;

        FolderMonitoringListener(FileDirectoryListenerInterface directoryListenerInterface, boolean monitorSubDirectories, FileFilter fileFilter) {
            this.directoryListenerInterface = directoryListenerInterface;
            this.monitorSubDirectories = monitorSubDirectories;
            this.fileFilter = fileFilter;
        }

        public void onFileCreate(File file) {
            log.debug("File created: " + file.getName());
            this.directoryListenerInterface.onFileCreate(file);
        }

        public void onFileDelete(File file) {
            log.debug("File deleted: " + file.getName());
            this.directoryListenerInterface.onFileDelete(file);
        }

        public void onFileChange(File file) {
            log.debug("File changed: " + file.getName());
            this.directoryListenerInterface.onFileChange(file);
        }

        public void onDirectoryCreate(File directory) {
            block3: {
                String methodName = "onDirectoryCreate";
                log.debug("Folder created: " + directory.getName());
                this.directoryListenerInterface.onDirectoryCreate(directory);
                if (this.monitorSubDirectories) {
                    try {
                        FilesListenerManager.this.registerDirectoryListener(this.directoryListenerInterface, directory, this.fileFilter);
                    }
                    catch (Exception error) {
                        if (FilesListenerManager.this.auditLog == null) break block3;
                        FilesListenerManager.this.auditLog.logException("onDirectoryCreate", OIFAuditCode.UNEXPECTED_EXC_MONITOR_START.getMessageDefinition(error.getClass().getName(), FilesListenerManager.this.connectorName, error.getMessage()), (Throwable)error);
                    }
                }
            }
        }

        public void onDirectoryDelete(File directory) {
            log.debug("Folder deleted: " + directory.getName());
            this.directoryListenerInterface.onDirectoryDelete(directory);
        }
    }
}

