/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.context;

import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.integration.reports.IntegrationReportWriter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ArchiveProperties;

public class OpenMetadataAccess
extends OpenMetadataStore {
    private final IntegrationReportWriter reportWriter;

    public OpenMetadataAccess(OpenMetadataClient openMetadataClient, String userId, String externalSourceGUID, String externalSourceName, String originatorGUID, IntegrationReportWriter reportWriter) {
        super(openMetadataClient, userId, externalSourceGUID, externalSourceName, originatorGUID);
        this.reportWriter = reportWriter;
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.createMetadataElementInStore(metadataElementTypeName, initialStatus, properties);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.createMetadataElementInStore(metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public String createMetadataElementInStore(String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.createMetadataElementInStore(metadataElementTypeName, initialStatus, initialClassifications, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, properties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public String createMetadataElementInStore(String externalSourceGUID, String externalSourceName, String metadataElementTypeName, ElementStatus initialStatus, Map<String, ElementProperties> initialClassifications, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.createMetadataElementInStore(externalSourceGUID, externalSourceName, metadataElementTypeName, initialStatus, initialClassifications, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, properties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public String createMetadataElementFromTemplate(String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.createMetadataElementFromTemplate(metadataElementTypeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public String createMetadataElementFromTemplate(String externalSourceGUID, String externalSourceName, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.createMetadataElementFromTemplate(externalSourceGUID, externalSourceName, metadataElementTypeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public String getMetadataElementFromTemplate(String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.getMetadataElementFromTemplate(metadataElementTypeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public String getMetadataElementFromTemplate(String externalSourceGUID, String externalSourceName, String metadataElementTypeName, String anchorGUID, boolean isOwnAnchor, Date effectiveFrom, Date effectiveTo, String templateGUID, ElementProperties replacementProperties, Map<String, String> placeholderProperties, String parentGUID, String parentRelationshipTypeName, ElementProperties parentRelationshipProperties, boolean parentAtEnd1) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String metadataElementGUID = super.getMetadataElementFromTemplate(externalSourceGUID, externalSourceName, metadataElementTypeName, anchorGUID, isOwnAnchor, effectiveFrom, effectiveTo, templateGUID, replacementProperties, placeholderProperties, parentGUID, parentRelationshipTypeName, parentRelationshipProperties, parentAtEnd1);
        if (metadataElementGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(metadataElementGUID);
        }
        return metadataElementGUID;
    }

    public void updateMetadataElementInStore(String metadataElementGUID, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateMetadataElementInStore(metadataElementGUID, replaceProperties, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateMetadataElementInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateMetadataElementInStore(externalSourceGUID, externalSourceName, metadataElementGUID, replaceProperties, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateMetadataElementStatusInStore(String metadataElementGUID, ElementStatus newElementStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateMetadataElementStatusInStore(metadataElementGUID, newElementStatus);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateMetadataElementStatusInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, ElementStatus newElementStatus) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateMetadataElementStatusInStore(externalSourceGUID, externalSourceName, metadataElementGUID, newElementStatus);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateMetadataElementEffectivityInStore(String metadataElementGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateMetadataElementEffectivityInStore(metadataElementGUID, effectiveFrom, effectiveTo);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateMetadataElementEffectivityInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateMetadataElementEffectivityInStore(externalSourceGUID, externalSourceName, metadataElementGUID, effectiveFrom, effectiveTo);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void deleteMetadataElementInStore(String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.deleteMetadataElementInStore(metadataElementGUID);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(metadataElementGUID);
        }
    }

    public void deleteMetadataElementInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.deleteMetadataElementInStore(externalSourceGUID, externalSourceName, metadataElementGUID);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(metadataElementGUID);
        }
    }

    public void archiveMetadataElementInStore(String metadataElementGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.archiveMetadataElementInStore(metadataElementGUID, archiveProperties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(metadataElementGUID);
        }
    }

    public void archiveMetadataElementInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, ArchiveProperties archiveProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.archiveMetadataElementInStore(externalSourceGUID, externalSourceName, metadataElementGUID, archiveProperties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(metadataElementGUID);
        }
    }

    public void classifyMetadataElementInStore(String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.classifyMetadataElementInStore(metadataElementGUID, classificationName, effectiveFrom, effectiveTo, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void classifyMetadataElementInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.classifyMetadataElementInStore(externalSourceGUID, externalSourceName, metadataElementGUID, classificationName, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void classifyMetadataElementInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.classifyMetadataElementInStore(externalSourceGUID, externalSourceName, metadataElementGUID, classificationName, effectiveFrom, effectiveTo, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void reclassifyMetadataElementInStore(String metadataElementGUID, String classificationName, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.reclassifyMetadataElementInStore(metadataElementGUID, classificationName, replaceProperties, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void reclassifyMetadataElementInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.reclassifyMetadataElementInStore(externalSourceGUID, externalSourceName, metadataElementGUID, classificationName, replaceProperties, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateClassificationEffectivityInStore(String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateClassificationEffectivityInStore(metadataElementGUID, classificationName, effectiveFrom, effectiveTo);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void updateClassificationEffectivityInStore(String externalSourceGUID, String externalSourceName, String metadataElementGUID, String classificationName, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateClassificationEffectivityInStore(externalSourceGUID, externalSourceName, metadataElementGUID, classificationName, effectiveFrom, effectiveTo);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public void declassifyMetadataElementInStore(String metadataElementGUID, String classificationName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.declassifyMetadataElementInStore(metadataElementGUID, classificationName);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(metadataElementGUID);
        }
    }

    public String createRelatedElementsInStore(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipGUID = super.createRelatedElementsInStore(relationshipTypeName, metadataElement1GUID, metadataElement2GUID, effectiveFrom, effectiveTo, properties);
        if (relationshipGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(relationshipGUID);
        }
        return relationshipGUID;
    }

    public String createRelatedElementsInStore(String externalSourceGUID, String externalSourceName, String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, Date effectiveFrom, Date effectiveTo, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipGUID = super.createRelatedElementsInStore(externalSourceGUID, externalSourceName, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, effectiveFrom, effectiveTo, properties);
        if (relationshipGUID != null && this.reportWriter != null) {
            this.reportWriter.reportElementCreation(relationshipGUID);
        }
        return relationshipGUID;
    }

    public void updateRelatedElementsInStore(String relationshipGUID, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateRelatedElementsInStore(relationshipGUID, replaceProperties, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(relationshipGUID);
        }
    }

    public void updateRelatedElementsInStore(String externalSourceGUID, String externalSourceName, String relationshipGUID, boolean replaceProperties, ElementProperties properties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateRelatedElementsInStore(externalSourceGUID, externalSourceName, relationshipGUID, replaceProperties, properties);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(relationshipGUID);
        }
    }

    public void updateRelatedElementsEffectivityInStore(String relationshipGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateRelatedElementsEffectivityInStore(relationshipGUID, effectiveFrom, effectiveTo);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(relationshipGUID);
        }
    }

    public void updateRelatedElementsEffectivityInStore(String externalSourceGUID, String externalSourceName, String relationshipGUID, Date effectiveFrom, Date effectiveTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.updateRelatedElementsEffectivityInStore(externalSourceGUID, externalSourceName, relationshipGUID, effectiveFrom, effectiveTo);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementUpdate(relationshipGUID);
        }
    }

    public void deleteRelatedElementsInStore(String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.deleteRelatedElementsInStore(relationshipGUID);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(relationshipGUID);
        }
    }

    public void deleteRelatedElementsInStore(String externalSourceGUID, String externalSourceName, String relationshipGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        super.deleteRelatedElementsInStore(externalSourceGUID, externalSourceName, relationshipGUID);
        if (this.reportWriter != null) {
            this.reportWriter.reportElementDelete(relationshipGUID);
        }
    }
}

