/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum OIFErrorCode implements ExceptionMessageSet
{
    ENGAGE_IMPLEMENTATION_MISSING(400, "OIF-CONNECTOR-400-001", "The integration connector {0} has been configured to have its own thread to issue blocking calls but has not implemented the engage() method", "The integration daemon created a separate thread for this connector to enable it to issue blocking calls.  It called the engage() method on this thread.  However, the default implementation of the engage() method has been invoked suggesting that either the dedicated thread is not needed or there is an error in the implementation of the connector.  The integration daemon will terminate the thread once the engage() method returns.", "If the connector does not need to issue blocking calls update the configuration to remove the need for the dedicated thread.  Otherwise update the integration connector's implementation to override the default engage() method implementation."),
    NULL_OBJECT(400, "OIF-CONNECTOR-400-002", "The object passed on the {0} parameter of the {1} operation is null", "The system is unable to process the request without this object.", "Correct the code in the caller to provide the object.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private OIFErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

