/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.integration.reports;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IntegrationReportProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.integration.client.OpenIntegrationClient;

public class IntegrationReportWriter {
    private boolean activeReportPublishing = true;
    private final String userId;
    private final Map<String, String> anchorMap = new HashMap<String, String>();
    private final Map<String, String> anchorTypeMap = new HashMap<String, String>();
    private Set<String> createdElements = new HashSet<String>();
    private Set<String> updatedElements = new HashSet<String>();
    private Set<String> deletedElements = new HashSet<String>();
    private Map<String, String> additionalProperties = new HashMap<String, String>();
    private Date startDate = null;
    private Date completionDate = null;
    private final String serverName;
    private final String connectorId;
    private final String connectorName;
    private final OpenIntegrationClient openIntegrationClient;
    private final OpenMetadataClient openMetadataStore;
    private final PropertyHelper propertyHelper = new PropertyHelper();
    private final String sourceName = this.getClass().getName();

    public IntegrationReportWriter(String serverName, String connectorId, String connectorName, String userId, OpenIntegrationClient openIntegrationClient, OpenMetadataClient openMetadataStore) {
        this.serverName = serverName;
        this.connectorId = connectorId;
        this.connectorName = connectorName;
        this.userId = userId;
        this.openIntegrationClient = openIntegrationClient;
        this.openMetadataStore = openMetadataStore;
    }

    public void startRecording() {
        this.startDate = new Date();
        this.completionDate = null;
        this.createdElements = new HashSet<String>();
        this.updatedElements = new HashSet<String>();
        this.deletedElements = new HashSet<String>();
        this.additionalProperties = new HashMap<String, String>();
    }

    public void publishReport() throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (!(!this.activeReportPublishing || this.createdElements.isEmpty() && this.updatedElements.isEmpty() && this.deletedElements.isEmpty())) {
            this.getAllAnchors(this.createdElements);
            this.getAllAnchors(this.updatedElements);
            this.getAllAnchors(this.deletedElements);
            for (String anchorGUID : this.anchorMap.values()) {
                IntegrationReportProperties report = new IntegrationReportProperties();
                report.setServerName(this.serverName);
                report.setConnectorId(this.connectorId);
                report.setConnectorName(this.connectorName);
                report.setRefreshStartDate(this.startDate);
                report.setRefreshCompletionDate(this.completionDate);
                report.setAdditionalProperties(this.additionalProperties);
                List<String> elementList = this.getAllAnchoredElements(anchorGUID, this.createdElements);
                report.setCreatedElements(elementList);
                elementList = this.getAllAnchoredElements(anchorGUID, this.updatedElements);
                report.setUpdatedElements(elementList);
                elementList = this.getAllAnchoredElements(anchorGUID, this.deletedElements);
                report.setDeletedElements(elementList);
                this.openIntegrationClient.publishIntegrationReport(this.userId, anchorGUID, report);
            }
        }
        this.startRecording();
    }

    private void getAllAnchors(Set<String> elementSet) throws UserNotAuthorizedException, PropertyServerException {
        for (String elementGUID : elementSet) {
            this.getAnchor(elementGUID);
        }
    }

    private List<String> getAllAnchoredElements(String anchorGUID, Set<String> elementSet) {
        ArrayList<String> anchoredElements = new ArrayList<String>();
        for (String elementGUID : elementSet) {
            String elementAnchorGUID = this.anchorMap.get(elementGUID);
            if (!anchorGUID.equals(elementAnchorGUID)) continue;
            anchoredElements.add(elementGUID);
        }
        if (!anchoredElements.isEmpty()) {
            return anchoredElements;
        }
        return null;
    }

    public void setActiveReportPublishing(boolean flag) {
        this.activeReportPublishing = flag;
    }

    public void setAnchor(String elementGUID, String anchorGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OpenMetadataElement anchorElement;
        this.anchorMap.put(elementGUID, anchorGUID);
        if (this.anchorTypeMap.get(anchorGUID) != null && (anchorElement = this.openMetadataStore.getMetadataElementByGUID(this.userId, anchorGUID, false, false, null, new Date())) != null) {
            this.anchorTypeMap.put(anchorGUID, anchorElement.getType().getTypeName());
        }
    }

    public void setAnchor(String elementGUID, String anchorGUID, String anchorTypeName) {
        this.anchorMap.put(elementGUID, anchorGUID);
        this.anchorTypeMap.put(anchorGUID, anchorTypeName);
    }

    public void setParent(String elementGUID, String parentGUID) {
        String parentAnchorGUID = this.anchorMap.get(parentGUID);
        if (parentAnchorGUID != null) {
            this.anchorMap.put(elementGUID, parentAnchorGUID);
        }
    }

    private void getAnchor(String elementGUID) throws UserNotAuthorizedException, PropertyServerException {
        String methodName = "getAnchor";
        if (!this.anchorMap.containsKey(elementGUID)) {
            List classifications;
            OpenMetadataElement metadataElement;
            try {
                metadataElement = this.openMetadataStore.getMetadataElementByGUID(this.userId, elementGUID, true, true, null, new Date());
            }
            catch (InvalidParameterException notKnown) {
                metadataElement = null;
            }
            if (metadataElement != null && (classifications = metadataElement.getClassifications()) != null) {
                for (AttachedClassification classification : classifications) {
                    if (classification == null || !"Anchors".equals(classification.getClassificationName())) continue;
                    String anchorGUIDPropertyName = "anchorGUID";
                    String anchorTypeNamePropertyName = "anchorTypeName";
                    String anchorGUID = this.propertyHelper.getStringProperty(this.sourceName, anchorGUIDPropertyName, classification.getClassificationProperties(), "getAnchor");
                    String anchorTypeName = this.propertyHelper.getStringProperty(this.sourceName, anchorTypeNamePropertyName, classification.getClassificationProperties(), "getAnchor");
                    if (anchorGUID == null) {
                        anchorGUID = elementGUID;
                        anchorTypeName = metadataElement.getType().getTypeName();
                    }
                    this.setAnchor(elementGUID, anchorGUID, anchorTypeName);
                }
            }
        }
    }

    public void reportElementCreation(String elementGUID) {
        this.createdElements.add(elementGUID);
    }

    public void reportElementUpdate(String elementGUID) {
        this.updatedElements.add(elementGUID);
    }

    public void reportElementDelete(String elementGUID) {
        this.deletedElements.add(elementGUID);
    }
}

