/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.odpi.openmetadata.accessservices.assetlineage.event.LineageEvent;
import org.odpi.openmetadata.accessservices.assetlineage.model.GraphContext;
import org.odpi.openmetadata.accessservices.assetlineage.model.LineageEntity;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.governanceservers.openlineage.buffergraph.BufferGraphConnectorBase;
import org.odpi.openmetadata.governanceservers.openlineage.ffdc.OpenLineageException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph.GraphVertexMapper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.buffergraph.MainGraphMapper;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.GraphFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferGraphConnector
extends BufferGraphConnectorBase {
    private static final Logger log = LoggerFactory.getLogger(BufferGraphConnector.class);
    private JanusGraph bufferGraph;
    private GraphVertexMapper graphVertexMapper = new GraphVertexMapper();
    private JanusGraph mainGraph;

    public void initializeGraphDB() throws OpenLineageException {
        String graphDB = this.connectionProperties.getConfigurationProperties().get("graphDB").toString();
        GraphFactory graphFactory = new GraphFactory();
        try {
            this.bufferGraph = graphFactory.openGraph(graphDB, this.connectionProperties);
        }
        catch (JanusConnectorException error) {
            log.error("The Buffer graph could not be initialized due to an error", (Throwable)error);
            throw new OpenLineageException(500, error.getReportingClassName(), error.getReportingActionDescription(), error.getReportedErrorMessage(), error.getReportedSystemAction(), error.getReportedUserAction());
        }
    }

    public void setMainGraph(Object mainGraph) {
        this.mainGraph = (JanusGraph)mainGraph;
    }

    public void schedulerTask() {
        GraphTraversalSource g = this.bufferGraph.traversal();
        try {
            List vertices = g.V(new Object[0]).has("vertex--label", (Object)"Process").toList();
            List guidList = vertices.stream().map(v -> (String)v.property("vertex--guid").value()).collect(Collectors.toList());
            guidList.stream().forEach(process -> this.findInputColumns(g, (String)process));
            g.tx().commit();
        }
        catch (Exception e) {
            log.error("Something went wrong when trying to map a process from bufferGraph to the mainGraph. The error is {}", (Object)e.getMessage());
            g.tx().rollback();
        }
    }

    private void findInputColumns(GraphTraversalSource g, String guid) {
        List inputPathsForColumns = g.V(new Object[0]).has("vertex--guid", (Object)guid).out(new String[]{"ProcessPort"}).out(new String[]{"PortDelegation"}).has("PortImplementation", "vertex--InstancePropportType", (Object)"INPUT_PORT").out(new String[]{"PortSchema"}).in(new String[]{"AttributeForSchema"}).out(new String[]{"LineageMapping"}).or(new Traversal[]{__.out((String[])new String[]{"AttributeForSchema"}).out(new String[]{"AssetSchemaType"}).has("vertex--label", (Object)"DataFile"), __.out((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable")}).toList();
        Vertex process = (Vertex)g.V(new Object[0]).has("vertex--guid", (Object)guid).next();
        inputPathsForColumns.stream().forEach(columnIn -> this.findOutputColumn(g, (Vertex)columnIn, process));
    }

    private void findOutputColumn(GraphTraversalSource g, Vertex columnIn, Vertex process) {
        List schemaElementVertex = g.V(new Object[0]).has("vertex--guid", columnIn.property("vertex--guid").value()).in(new String[]{"LineageMapping"}).toList();
        Vertex vertexToStart = null;
        if (schemaElementVertex != null) {
            Vertex columnOut = null;
            vertexToStart = this.getProcessForTheSchemaElement(g, schemaElementVertex, process);
            if (vertexToStart != null) {
                columnOut = this.findPathForOutputAsset(vertexToStart, g, columnIn);
            }
            this.moveColumnProcessColumn(columnIn, columnOut, process);
        }
    }

    private Vertex getProcessForTheSchemaElement(GraphTraversalSource g, List<Vertex> schemaElementVertex, Vertex process) {
        Vertex vertexToStart = null;
        for (Vertex v : schemaElementVertex) {
            List initialProcess = g.V(new Object[]{v.id()}).bothE(new String[]{"AttributeForSchema"}).otherV().inE(new String[]{"PortSchema"}).otherV().inE(new String[]{"PortDelegation"}).otherV().inE(new String[]{"ProcessPort"}).otherV().has("vertex--guid", process.property("vertex--guid").value()).toList();
            if (initialProcess.isEmpty()) continue;
            vertexToStart = v;
            break;
        }
        return vertexToStart;
    }

    private void moveColumnProcessColumn(Vertex columnIn, Vertex columnOut, Vertex process) {
        if (columnOut != null) {
            String columnOutGuid = columnOut.values(new String[]{"vertex--guid"}).next().toString();
            String columnInGuid = columnIn.values(new String[]{"vertex--guid"}).next().toString();
            if (!columnOutGuid.isEmpty() && !columnInGuid.isEmpty()) {
                MainGraphMapper mainGraphMapper = new MainGraphMapper(this.bufferGraph, this.mainGraph);
                mainGraphMapper.checkBufferGraph(columnInGuid, columnOutGuid, process);
            }
        }
    }

    public void addEntity(LineageEvent lineageEvent) {
        GraphTraversalSource g = this.bufferGraph.traversal();
        HashSet verticesToBeAdded = new HashSet();
        lineageEvent.getAssetContext().entrySet().stream().forEach(entry -> {
            if (((Set)entry.getValue()).size() > 1) {
                verticesToBeAdded.addAll((Collection)entry.getValue());
            } else {
                verticesToBeAdded.add(((Set)entry.getValue()).stream().findFirst().get());
            }
        });
        verticesToBeAdded.stream().forEach(entry -> {
            try {
                this.addVerticesAndRelationship(g, (GraphContext)entry);
            }
            catch (JanusConnectorException e) {
                log.error("An exception happened when trying to create vertices and relationships in BufferGraph. The error is {}", (Throwable)e);
            }
        });
    }

    private void addVerticesAndRelationship(GraphTraversalSource g, GraphContext nodeToNode) throws JanusConnectorException {
        LineageEntity fromEntity = nodeToNode.getFromVertex();
        LineageEntity toEntity = nodeToNode.getToVertex();
        Vertex vertexFrom = this.addVertex(g, fromEntity);
        Vertex vertexTo = this.addVertex(g, toEntity);
        if (vertexFrom != null && vertexTo != null) {
            this.addRelationship(nodeToNode.getRelationshipGuid(), nodeToNode.getRelationshipType(), vertexFrom, vertexTo);
        }
    }

    private Vertex addVertex(GraphTraversalSource g, LineageEntity lineageEntity) throws JanusConnectorException {
        Vertex vertex;
        GraphTraversal vertexIt = g.V(new Object[0]).has("vertex--guid", (Object)lineageEntity.getGuid());
        if (!vertexIt.hasNext()) {
            vertex = (Vertex)g.addV(lineageEntity.getTypeDefName()).next();
            this.addPropertiesToVertex(g, vertex, lineageEntity);
            g.tx().commit();
        } else {
            vertex = (Vertex)vertexIt.next();
            if (log.isDebugEnabled()) {
                log.debug("found existing vertex {} when trying to add it in bufferGraph", (Object)vertex);
            }
            g.tx().rollback();
        }
        return vertex;
    }

    private void addRelationship(String relationshipGuid, String relationshipType, Vertex fromVertex, Vertex toVertex) throws JanusConnectorException {
        String methodName = "addRelationship";
        GraphTraversalSource g = this.bufferGraph.traversal();
        if (relationshipType == null) {
            log.error("Relationship type name is missing");
            this.throwException(JanusConnectorErrorCode.RELATIONSHIP_TYPE_NAME_NOT_KNOWN, relationshipGuid, methodName);
        }
        try {
            GraphTraversal edgeIt = g.E(new Object[0]).has("edge--guid", (Object)relationshipGuid);
            if (edgeIt.hasNext()) {
                g.tx().rollback();
                log.debug("found existing edge {}", (Object)edgeIt);
                return;
            }
            fromVertex.addEdge(relationshipType, toVertex, new Object[0]).property("edge--guid", (Object)relationshipGuid);
            g.tx().commit();
        }
        catch (Exception e) {
            g.tx().rollback();
        }
    }

    private void addPropertiesToVertex(GraphTraversalSource g, Vertex vertex, LineageEntity lineageEntity) throws JanusConnectorException {
        String methodName = "addPropertiesToVertex";
        try {
            this.graphVertexMapper.mapEntityToVertex(lineageEntity, vertex);
        }
        catch (Exception e) {
            log.error("Caught exception from entity mapper {}", (Object)e.getMessage());
            g.tx().rollback();
            this.throwException(JanusConnectorErrorCode.ENTITY_NOT_CREATED, lineageEntity.getGuid(), "addPropertiesToVertex");
        }
    }

    public void updateEntity(LineageEvent lineageEvent) {
    }

    public void deleteEntity(String guid) {
        GraphTraversalSource g = this.bufferGraph.traversal();
        if (this.checkIfVertexExist(g, guid)) {
            g.V(new Object[0]).has("vertex--guid", (Object)guid).drop();
            g.tx().commit();
            log.debug("Vertex with guid {} deleted", (Object)guid);
        }
        g.tx().rollback();
        log.debug("Vertex with guid did not delete {}", (Object)guid);
    }

    private Vertex findPathForOutputAsset(Vertex endingVertex, GraphTraversalSource g, Vertex startingVertex) {
        String VERTEX = "vertex";
        try {
            GraphTraversal end = g.V(new Object[]{endingVertex.id()}).or(new Traversal[]{__.out((String[])new String[]{"AttributeForSchema"}).out(new String[]{"AssetSchemaType"}).has("vertex--label", (Object)"DataFile").store("vertex"), __.out((String[])new String[]{"NestedSchemaAttribute"}).has("vertex--label", (Object)"RelationalTable").store("vertex")}).select("vertex").unfold();
            if (!end.hasNext()) {
                List next = g.V(new Object[]{endingVertex.id()}).both(new String[]{"LineageMapping"}).toList();
                Vertex nextVertex = null;
                for (Vertex vert : next) {
                    if (vert.equals(startingVertex)) continue;
                    nextVertex = vert;
                }
                return this.findPathForOutputAsset(nextVertex, g, endingVertex);
            }
            return endingVertex;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Vertex does not exist {}", startingVertex.id());
            }
            return null;
        }
    }

    private boolean checkIfVertexExist(GraphTraversalSource g, String guid) {
        return g.V(new Object[0]).has("vertex--guid", (Object)guid).hasNext();
    }

    private void throwException(JanusConnectorErrorCode errorCode, String guid, String methodName) throws JanusConnectorException {
        String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(guid, methodName, ((Object)((Object)this)).getClass().getName());
        throw new JanusConnectorException(((Object)((Object)this)).getClass().getName(), methodName, errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
    }

    public void disconnect() throws ConnectorCheckedException {
        this.bufferGraph.close();
        super.disconnect();
    }
}

