/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.IndexingFactory;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory.JanusFactoryBeans;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.JanusConnectorErrorCode;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.model.ffdc.JanusConnectorException;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.EdgeLabelsBufferGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.EdgeLabelsMainGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.VertexLabelsBufferGraph;
import org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.utils.VertexLabelsMainGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFactory
extends IndexingFactory {
    private static final Logger log = LoggerFactory.getLogger(GraphFactory.class);
    private JanusFactoryBeans janusFactoryBeans = new JanusFactoryBeans();

    public JanusGraph openGraph(String graphDB, ConnectionProperties connectionProperties) throws JanusConnectorException {
        String methodName = "open";
        String graphType = (String)connectionProperties.getConfigurationProperties().get("graphType");
        JanusGraphFactory.Builder config = this.janusFactoryBeans.getJanusFactory(graphDB, connectionProperties, graphType);
        try {
            JanusGraph janusGraph = config.open();
            return this.initializeGraph(janusGraph, graphType);
        }
        catch (Exception e) {
            log.error("{} could not open graph store with the specified configuration", (Throwable)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.CANNOT_OPEN_GRAPH_DB;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "open", GraphFactory.class.getName());
            throw new JanusConnectorException(GraphFactory.class.getName(), "open", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private JanusGraph initializeGraph(JanusGraph janusGraph, String graphType) throws JanusConnectorException {
        String methodName = "initializeGraph";
        log.info("Updating graph schema, if necessary");
        try {
            JanusGraphManagement management = janusGraph.openManagement();
            Set<Object> vertexLabels = new HashSet();
            HashSet<String> relationshipsLabels = new HashSet();
            if (graphType.equals("bufferGraph")) {
                vertexLabels = this.schemaBasedOnGraphType(VertexLabelsBufferGraph.class);
                relationshipsLabels = this.schemaBasedOnGraphType(EdgeLabelsBufferGraph.class);
            }
            if (graphType.equals("mainGraph")) {
                vertexLabels = this.schemaBasedOnGraphType(VertexLabelsMainGraph.class);
                relationshipsLabels = this.schemaBasedOnGraphType(EdgeLabelsMainGraph.class);
            }
            management = this.checkAndAddLabelVertexOrEdge(vertexLabels, management, "vertex");
            management = this.checkAndAddLabelVertexOrEdge(relationshipsLabels, management, "edge");
            management.commit();
            this.createIndexes(janusGraph, graphType);
            return janusGraph;
        }
        catch (Exception e) {
            log.error("{} failed  during graph initialize operation with error: {}", (Object)graphType, (Object)e);
            JanusConnectorErrorCode errorCode = JanusConnectorErrorCode.GRAPH_INITIALIZATION_ERROR;
            String errorMessage = errorCode.getErrorMessageId() + errorCode.getFormattedErrorMessage(e.getMessage(), "initializeGraph", GraphFactory.class.getName());
            throw new JanusConnectorException(GraphFactory.class.getName(), "initializeGraph", errorMessage, errorCode.getSystemAction(), errorCode.getUserAction());
        }
    }

    private <T extends Enum<T>> Set<String> schemaBasedOnGraphType(Class<T> aEnum) {
        return Stream.of(aEnum.getEnumConstants()).map(Enum::name).collect(Collectors.toSet());
    }

    private JanusGraphManagement checkAndAddLabelVertexOrEdge(Set<String> labels, JanusGraphManagement management, String type) {
        if (type.equals("vertex")) {
            for (String label : labels) {
                if (management.getVertexLabel(label) != null) continue;
                management.makeVertexLabel(label).make();
            }
        }
        if (type.equals("edge")) {
            for (String label : labels) {
                if (management.getEdgeLabel(label) != null) continue;
                management.makeEdgeLabel(label).make();
            }
        }
        return management;
    }

    private void createIndexes(JanusGraph janusGraph, String graphType) {
        if (graphType.equals("bufferGraph")) {
            this.createIndexesBuffer(janusGraph);
        }
        if (graphType.equals("mainGraph")) {
            this.createIndexesMainGraph(janusGraph);
        }
    }

    private void createIndexesBuffer(JanusGraph janusGraph) {
        this.createCompositeIndexForProperty("guid", "vertex--guid", true, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("label", "vertex--label", false, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("label", "edge--label", false, janusGraph, Edge.class);
        this.createCompositeIndexForProperty("guid", "edge--guid", false, janusGraph, Edge.class);
    }

    private void createIndexesMainGraph(JanusGraph janusGraph) {
        this.createCompositeIndexForProperty("nodeID", "vertex--nodeID", true, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("guid", "vertex--guid", false, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("label", "vertex--label", false, janusGraph, Vertex.class);
        this.createCompositeIndexForProperty("label", "edge--label", false, janusGraph, Edge.class);
    }
}

