/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.openconnectors.governancedaemonconnectors.openlineageconnectors.janusconnector.factory;

import java.util.ArrayList;
import org.janusgraph.core.JanusGraphFactory;
import org.odpi.openmetadata.frameworks.connectors.properties.ConnectionProperties;

public class JanusFactoryBeans {
    public JanusGraphFactory.Builder getJanusFactory(String graphDB, ConnectionProperties connectionProperties, String graphType) {
        if (graphDB.equals("berkeleydb")) {
            return this.janusFactoryBerkley(connectionProperties, graphType);
        }
        if (graphDB.equals("cassandra")) {
            return this.janusFactoryCassandra(connectionProperties);
        }
        return null;
    }

    private JanusGraphFactory.Builder janusFactoryCassandra(ConnectionProperties connectionProperties) {
        String listString = String.join((CharSequence)",", (ArrayList)connectionProperties.getConfigurationProperties().get("storageHostname"));
        return JanusGraphFactory.build().set("storage.backend", connectionProperties.getConfigurationProperties().get("storageBackend")).set("storage.username", connectionProperties.getConfigurationProperties().get("username")).set("storage.password", connectionProperties.getConfigurationProperties().get("password")).set("storage.hostname", (Object)listString).set("storage.cql.cluster-name", connectionProperties.getConfigurationProperties().get("clusterName")).set("storage.cql.keyspace", connectionProperties.getConfigurationProperties().get("storageCqlKeyspace")).set("index.search.backend", connectionProperties.getConfigurationProperties().get("indexSearchBackend")).set("index.search.hostname", connectionProperties.getConfigurationProperties().get("indexSearchHostname"));
    }

    private JanusGraphFactory.Builder janusFactoryBerkley(ConnectionProperties connectionProperties, String graphType) {
        String storagePath = "./egeria-lineage-repositories/" + graphType + "/berkeley";
        String indexPath = "./egeria-lineage-repositories/" + graphType + "/searchindex";
        return JanusGraphFactory.build().set("storage.backend", connectionProperties.getConfigurationProperties().get("storageBackend")).set("storage.directory", (Object)storagePath).set("index.search.backend", connectionProperties.getConfigurationProperties().get("indexSearchBackend")).set("index.search.directory", (Object)indexPath);
    }
}

